/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dataset.states;

import java.util.ArrayList;
import org.seasar.extension.dataset.DataColumn;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.PrimaryKeyNotFoundRuntimeException;
import org.seasar.extension.dataset.states.AbstractRowState;
import org.seasar.extension.dataset.states.SqlContext;

public class ModifiedState
extends AbstractRowState {
    public String toString() {
        return "MODIFIED";
    }

    protected SqlContext getSqlContext(DataRow row) {
        DataTable table = row.getTable();
        StringBuffer buf = new StringBuffer(100);
        ArrayList<Object> argList = new ArrayList<Object>();
        ArrayList<Class> argTypeList = new ArrayList<Class>();
        buf.append("UPDATE ");
        buf.append(table.getTableName());
        buf.append(" SET ");
        for (int i = 0; i < table.getColumnSize(); ++i) {
            DataColumn column = table.getColumn(i);
            if (!column.isWritable() || column.isPrimaryKey()) continue;
            buf.append(column.getColumnName());
            buf.append(" = ?, ");
            argList.add(row.getValue(i));
            argTypeList.add(column.getColumnType().getType());
        }
        buf.setLength(buf.length() - 2);
        buf.append(" WHERE ");
        boolean hasPrimaryKey = false;
        for (int i = 0; i < table.getColumnSize(); ++i) {
            DataColumn column = table.getColumn(i);
            if (!column.isPrimaryKey()) continue;
            hasPrimaryKey = true;
            buf.append(column.getColumnName());
            buf.append(" = ? AND ");
            argList.add(row.getValue(i));
            argTypeList.add(column.getColumnType().getType());
        }
        if (!hasPrimaryKey) {
            throw new PrimaryKeyNotFoundRuntimeException(table.getTableName());
        }
        buf.setLength(buf.length() - 5);
        return new SqlContext(buf.toString(), argList.toArray(), argTypeList.toArray(new Class[argTypeList.size()]));
    }
}

