/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ConcurrentLRUCache;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.search.CacheRegenerator;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;

public class FastLRUCache
implements SolrCache {
    private List<ConcurrentLRUCache.Stats> statsList;
    private long warmupTime = 0L;
    private String name;
    private int autowarmCount;
    private SolrCache.State state;
    private CacheRegenerator regenerator;
    private String description = "Concurrent LRU Cache";
    private ConcurrentLRUCache cache;
    private int showItems = 0;

    public Object init(Map args, Object persistence, CacheRegenerator regenerator) {
        this.state = SolrCache.State.CREATED;
        this.regenerator = regenerator;
        this.name = (String)args.get("name");
        String str = (String)args.get("size");
        int limit = str == null ? 1024 : Integer.parseInt(str);
        str = (String)args.get("minSize");
        int minLimit = str == null ? (int)((double)limit * 0.9) : Integer.parseInt(str);
        if (minLimit == 0) {
            minLimit = 1;
        }
        if (limit <= minLimit) {
            limit = minLimit + 1;
        }
        int acceptableLimit = (str = (String)args.get("acceptableSize")) == null ? (int)((double)limit * 0.95) : Integer.parseInt(str);
        acceptableLimit = Math.max(minLimit, acceptableLimit);
        str = (String)args.get("initialSize");
        int initialSize = str == null ? limit : Integer.parseInt(str);
        str = (String)args.get("autowarmCount");
        this.autowarmCount = str == null ? 0 : Integer.parseInt(str);
        str = (String)args.get("cleanupThread");
        boolean newThread = str == null ? false : Boolean.parseBoolean(str);
        str = (String)args.get("showItems");
        this.showItems = str == null ? 0 : Integer.parseInt(str);
        this.description = "Concurrent LRU Cache(maxSize=" + limit + ", initialSize=" + initialSize + ", minSize=" + minLimit + ", acceptableSize=" + acceptableLimit + ", cleanupThread=" + newThread;
        if (this.autowarmCount > 0) {
            this.description = this.description + ", autowarmCount=" + this.autowarmCount + ", regenerator=" + regenerator;
        }
        this.description = this.description + ')';
        this.cache = new ConcurrentLRUCache(limit, minLimit, acceptableLimit, initialSize, newThread, false, null);
        this.cache.setAlive(false);
        this.statsList = (List)persistence;
        if (this.statsList == null) {
            this.statsList = new CopyOnWriteArrayList<ConcurrentLRUCache.Stats>();
            this.statsList.add(new ConcurrentLRUCache.Stats());
        }
        this.statsList.add(this.cache.getStats());
        return this.statsList;
    }

    public String name() {
        return this.name;
    }

    public int size() {
        return this.cache.size();
    }

    public Object put(Object key, Object value) {
        return this.cache.put(key, value);
    }

    public Object get(Object key) {
        return this.cache.get(key);
    }

    public void clear() {
        this.cache.clear();
    }

    public void setState(SolrCache.State state) {
        this.state = state;
        this.cache.setAlive(state == SolrCache.State.LIVE);
    }

    public SolrCache.State getState() {
        return this.state;
    }

    public void warm(SolrIndexSearcher searcher, SolrCache old) throws IOException {
        if (this.regenerator == null) {
            return;
        }
        long warmingStartTime = System.currentTimeMillis();
        FastLRUCache other = (FastLRUCache)old;
        if (this.autowarmCount != 0) {
            int sz = other.size();
            if (this.autowarmCount != -1) {
                sz = Math.min(sz, this.autowarmCount);
            }
            Map items = other.cache.getLatestAccessedItems(sz);
            Map.Entry[] itemsArr = new Map.Entry[items.size()];
            int counter = 0;
            for (Map.Entry mapEntry : items.entrySet()) {
                itemsArr[counter++] = mapEntry;
            }
            for (int i = itemsArr.length - 1; i >= 0; --i) {
                try {
                    boolean continueRegen = this.regenerator.regenerateItem(searcher, this, old, itemsArr[i].getKey(), itemsArr[i].getValue());
                    if (continueRegen) continue;
                    break;
                }
                catch (Throwable e) {
                    SolrException.log((Logger)log, (String)("Error during auto-warming of key:" + itemsArr[i].getKey()), (Throwable)e);
                }
            }
        }
        this.warmupTime = System.currentTimeMillis() - warmingStartTime;
    }

    public void close() {
        this.statsList.get(0).add(this.cache.getStats());
        this.statsList.remove(this.cache.getStats());
        this.cache.destroy();
    }

    public String getName() {
        return FastLRUCache.class.getName();
    }

    public String getVersion() {
        return "1.0";
    }

    public String getDescription() {
        return this.description;
    }

    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.CACHE;
    }

    public String getSourceId() {
        return "$Id: FastLRUCache.java 949476 2010-05-30 04:53:00Z hossman $";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.4/src/java/org/apache/solr/search/FastLRUCache.java $";
    }

    public URL[] getDocs() {
        return null;
    }

    private static String calcHitRatio(long lookups, long hits) {
        if (lookups == 0L) {
            return "0.00";
        }
        if (lookups == hits) {
            return "1.00";
        }
        int hundredths = (int)(hits * 100L / lookups);
        if (hundredths < 10) {
            return "0.0" + hundredths;
        }
        return "0." + hundredths;
    }

    public NamedList getStatistics() {
        SimpleOrderedMap lst = new SimpleOrderedMap();
        if (this.cache == null) {
            return lst;
        }
        ConcurrentLRUCache.Stats stats = this.cache.getStats();
        long lookups = stats.getCumulativeLookups();
        long hits = stats.getCumulativeHits();
        long inserts = stats.getCumulativePuts();
        long evictions = stats.getCumulativeEvictions();
        long size = stats.getCurrentSize();
        lst.add("lookups", (Object)lookups);
        lst.add("hits", (Object)hits);
        lst.add("hitratio", (Object)FastLRUCache.calcHitRatio(lookups, hits));
        lst.add("inserts", (Object)inserts);
        lst.add("evictions", (Object)evictions);
        lst.add("size", (Object)size);
        lst.add("warmupTime", (Object)this.warmupTime);
        long clookups = 0L;
        long chits = 0L;
        long cinserts = 0L;
        long cevictions = 0L;
        for (ConcurrentLRUCache.Stats statistiscs : this.statsList) {
            clookups += statistiscs.getCumulativeLookups();
            chits += statistiscs.getCumulativeHits();
            cinserts += statistiscs.getCumulativePuts();
            cevictions += statistiscs.getCumulativeEvictions();
        }
        lst.add("cumulative_lookups", (Object)clookups);
        lst.add("cumulative_hits", (Object)chits);
        lst.add("cumulative_hitratio", (Object)FastLRUCache.calcHitRatio(clookups, chits));
        lst.add("cumulative_inserts", (Object)cinserts);
        lst.add("cumulative_evictions", (Object)cevictions);
        if (this.showItems != 0) {
            Map items = this.cache.getLatestAccessedItems(this.showItems == -1 ? Integer.MAX_VALUE : this.showItems);
            for (Map.Entry e : items.entrySet()) {
                Object k = e.getKey();
                Object v = e.getValue();
                String ks = "item_" + k;
                String vs = v.toString();
                lst.add(ks, (Object)vs);
            }
        }
        return lst;
    }

    public String toString() {
        return this.name + this.getStatistics().toString();
    }
}

