/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataConfig;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.apache.solr.handler.dataimport.EntityProcessor;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.apache.solr.handler.dataimport.VariableResolverImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextImpl
extends Context {
    private DataConfig.Entity entity;
    private ContextImpl parent;
    private VariableResolverImpl resolver;
    private DataSource ds;
    private String currProcess;
    private Map<String, Object> requestParams;
    private DataImporter dataImporter;
    private Map<String, Object> entitySession;
    private Map<String, Object> globalSession;
    DocBuilder.DocWrapper doc;
    DocBuilder docBuilder;

    public ContextImpl(DataConfig.Entity entity, VariableResolverImpl resolver, DataSource ds, String currProcess, Map<String, Object> global, ContextImpl parentContext, DocBuilder docBuilder) {
        this.entity = entity;
        this.docBuilder = docBuilder;
        this.resolver = resolver;
        this.ds = ds;
        this.currProcess = currProcess;
        if (docBuilder != null) {
            this.requestParams = docBuilder.requestParameters.requestParams;
            this.dataImporter = docBuilder.dataImporter;
        }
        this.globalSession = global;
        this.parent = parentContext;
    }

    @Override
    public String getEntityAttribute(String name) {
        return this.entity == null ? null : this.entity.allAttributes.get(name);
    }

    @Override
    public String getResolvedEntityAttribute(String name) {
        return this.entity == null ? null : this.resolver.replaceTokens(this.entity.allAttributes.get(name));
    }

    @Override
    public List<Map<String, String>> getAllEntityFields() {
        return this.entity == null ? Collections.EMPTY_LIST : this.entity.allFieldsList;
    }

    @Override
    public VariableResolver getVariableResolver() {
        return this.resolver;
    }

    @Override
    public DataSource getDataSource() {
        if (this.ds != null) {
            return this.ds;
        }
        if (this.entity == null) {
            return null;
        }
        if (this.entity.dataSrc == null) {
            this.entity.dataSrc = this.dataImporter.getDataSourceInstance(this.entity, this.entity.dataSource, this);
        }
        if (this.entity.dataSrc != null && this.docBuilder != null && this.docBuilder.verboseDebug && "FULL_DUMP".equals(this.currentProcess())) {
            this.entity.dataSrc = this.docBuilder.writer.getDebugLogger().wrapDs(this.entity.dataSrc);
        }
        return this.entity.dataSrc;
    }

    @Override
    public DataSource getDataSource(String name) {
        return this.dataImporter.getDataSourceInstance(this.entity, name, this);
    }

    @Override
    public boolean isRootEntity() {
        return this.entity.isDocRoot;
    }

    @Override
    public String currentProcess() {
        return this.currProcess;
    }

    @Override
    public Map<String, Object> getRequestParameters() {
        return this.requestParams;
    }

    @Override
    public EntityProcessor getEntityProcessor() {
        return this.entity == null ? null : this.entity.processor;
    }

    @Override
    public void setSessionAttribute(String name, Object val, String scope) {
        if ("entity".equals(scope)) {
            if (this.entitySession == null) {
                this.entitySession = new HashMap<String, Object>();
            }
            this.entitySession.put(name, val);
        } else if ("global".equals(scope)) {
            if (this.globalSession != null) {
                this.globalSession.put(name, val);
            }
        } else if ("document".equals(scope)) {
            DocBuilder.DocWrapper doc = this.getDocument();
            if (doc != null) {
                doc.setSessionAttribute(name, val);
            }
        } else if ("solrcore".equals(scope) && this.dataImporter != null) {
            this.dataImporter.getCoreScopeSession().put(name, val);
        }
    }

    @Override
    public Object getSessionAttribute(String name, String scope) {
        if ("entity".equals(scope)) {
            if (this.entitySession == null) {
                return null;
            }
            return this.entitySession.get(name);
        }
        if ("global".equals(scope)) {
            if (this.globalSession != null) {
                return this.globalSession.get(name);
            }
        } else {
            if ("document".equals(scope)) {
                DocBuilder.DocWrapper doc = this.getDocument();
                return doc == null ? null : doc.getSessionAttribute(name);
            }
            if ("solrcore".equals(scope)) {
                return this.dataImporter == null ? null : this.dataImporter.getCoreScopeSession().get(name);
            }
        }
        return null;
    }

    @Override
    public Context getParentContext() {
        return this.parent;
    }

    private DocBuilder.DocWrapper getDocument() {
        ContextImpl c = this;
        while (true) {
            if (c.doc != null) {
                return c.doc;
            }
            if (c.parent == null) break;
            c = c.parent;
        }
        return null;
    }

    public void setDoc(DocBuilder.DocWrapper docWrapper) {
        this.doc = docWrapper;
    }

    @Override
    public SolrCore getSolrCore() {
        return this.dataImporter == null ? null : this.dataImporter.getCore();
    }

    @Override
    public Map<String, Object> getStats() {
        return this.docBuilder != null ? this.docBuilder.importStatistics.getStatsSnapshot() : Collections.emptyMap();
    }

    @Override
    public String getScript() {
        if (this.dataImporter != null) {
            DataConfig.Script script = this.dataImporter.getConfig().script;
            return script == null ? null : script.text;
        }
        return null;
    }

    @Override
    public String getScriptLanguage() {
        if (this.dataImporter != null) {
            DataConfig.Script script = this.dataImporter.getConfig().script;
            return script == null ? null : script.language;
        }
        return null;
    }

    @Override
    public void deleteDoc(String id) {
        if (this.docBuilder != null) {
            this.docBuilder.writer.deleteDoc(id);
        }
    }

    @Override
    public void deleteDocByQuery(String query) {
        if (this.docBuilder != null) {
            this.docBuilder.writer.deleteByQuery(query);
        }
    }
}

