/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.client.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashSet;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.util.FileUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.RobotCrawlAccessException;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.client.AbstractS2RobotClient;
import org.seasar.robot.client.fs.ChildUrlsException;
import org.seasar.robot.entity.ResponseData;
import org.seasar.robot.helper.ContentLengthHelper;
import org.seasar.robot.helper.MimeTypeHelper;
import org.seasar.robot.util.TemporaryFileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemClient
extends AbstractS2RobotClient {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemClient.class);
    protected String charset = "UTF-8";
    @Binding(bindingType=BindingType.MAY)
    @Resource
    protected ContentLengthHelper contentLengthHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResponseData doGet(String uri) {
        ResponseData responseData = new ResponseData();
        responseData.setMethod("GET");
        String filePath = this.preprocessUri(uri);
        responseData.setUrl(filePath);
        File file = null;
        try {
            file = new File(new URI(filePath));
        }
        catch (URISyntaxException e) {
            logger.warn("Could not parse url: " + filePath, (Throwable)e);
        }
        if (file == null) {
            responseData.setHttpStatusCode(404);
            responseData.setCharSet(this.charset);
            responseData.setContentLength(0L);
            return responseData;
        }
        if (file.isFile()) {
            block15: {
                MimeTypeHelper mimeTypeHelper = (MimeTypeHelper)SingletonS2Container.getComponent((String)"mimeTypeHelper");
                FileInputStream is = null;
                try {
                    try {
                        is = new FileInputStream(file);
                        responseData.setMimeType(mimeTypeHelper.getContentType((InputStream)is, file.getName()));
                    }
                    catch (Exception e) {
                        responseData.setMimeType(mimeTypeHelper.getContentType(null, file.getName()));
                        Object var9_11 = null;
                        IOUtils.closeQuietly((InputStream)is);
                        break block15;
                    }
                    Object var9_10 = null;
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    IOUtils.closeQuietly((InputStream)is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
            responseData.setContentLength(file.length());
            if (this.contentLengthHelper != null) {
                long maxLength = this.contentLengthHelper.getMaxLength(responseData.getMimeType());
                if (responseData.getContentLength() > maxLength) {
                    throw new RobotCrawlAccessException("The content length (" + responseData.getContentLength() + " byte) is over " + maxLength + " byte. The url is " + filePath);
                }
            }
            responseData.setHttpStatusCode(200);
            responseData.setCharSet(this.geCharSet(file));
            responseData.setLastModified(new Date(file.lastModified()));
            if (!file.canRead()) {
                responseData.setHttpStatusCode(403);
                return responseData;
            }
            File outputFile = null;
            try {
                outputFile = File.createTempFile("s2robot-FileSystemClient-", ".out");
                FileUtil.copy((File)file, (File)outputFile);
                responseData.setResponseBody(new TemporaryFileInputStream(outputFile));
                return responseData;
            }
            catch (Exception e) {
                logger.warn("I/O Exception.", (Throwable)e);
                responseData.setHttpStatusCode(500);
                if (outputFile == null) return responseData;
                if (outputFile.delete()) return responseData;
                logger.warn("Could not delete " + outputFile.getAbsolutePath());
                return responseData;
            }
        }
        if (!file.isDirectory()) {
            responseData.setHttpStatusCode(404);
            responseData.setCharSet(this.charset);
            responseData.setContentLength(0L);
            return responseData;
        }
        HashSet<String> childUrlSet = new HashSet<String>();
        File[] files = file.listFiles();
        if (files == null) throw new ChildUrlsException(childUrlSet);
        File[] arr$ = files;
        int len$ = arr$.length;
        int i$ = 0;
        while (i$ < len$) {
            File f = arr$[i$];
            String chileUri = f.toURI().toASCIIString();
            childUrlSet.add(chileUri);
            ++i$;
        }
        throw new ChildUrlsException(childUrlSet);
    }

    protected String preprocessUri(String uri) {
        if (StringUtil.isEmpty((String)uri)) {
            throw new RobotSystemException("The uri is empty.");
        }
        String filePath = uri;
        if (!filePath.startsWith("file:")) {
            filePath = "file://" + filePath;
        }
        StringBuilder buf = new StringBuilder(filePath.length() + 100);
        try {
            for (char c : filePath.toCharArray()) {
                if (c == ' ') {
                    buf.append("%20");
                    continue;
                }
                String str = String.valueOf(c);
                if (StringUtils.isAsciiPrintable((String)str)) {
                    buf.append(c);
                    continue;
                }
                buf.append(URLEncoder.encode(str, this.charset));
            }
        }
        catch (UnsupportedEncodingException e) {
            return filePath;
        }
        return buf.toString();
    }

    @Deprecated
    protected String decodeUri(String uri) {
        if (StringUtil.isBlank((String)uri)) {
            return uri;
        }
        try {
            return URLDecoder.decode(uri, this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RobotSystemException("Unsupported encoding: " + this.charset, e);
        }
    }

    protected String geCharSet(File file) {
        return this.charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public ResponseData doHead(String url) {
        try {
            ResponseData responseData = this.doGet(url);
            responseData.setMethod("HEAD");
            return responseData;
        }
        catch (ChildUrlsException e) {
            return null;
        }
    }
}

