/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.resource;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.seasar.robot.dbflute.AccessContext;
import org.seasar.robot.dbflute.DBDef;
import org.seasar.robot.dbflute.cbean.ConditionBean;
import org.seasar.robot.dbflute.cbean.ConditionBeanContext;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseCreator;
import org.seasar.robot.dbflute.dbmeta.DBMeta;
import org.seasar.robot.dbflute.dbmeta.DBMetaProvider;
import org.seasar.robot.dbflute.helper.StringSet;
import org.seasar.robot.dbflute.jdbc.ValueType;
import org.seasar.robot.dbflute.resource.ResourceParameter;
import org.seasar.robot.dbflute.twowaysql.SqlAnalyzer;
import org.seasar.robot.dbflute.twowaysql.factory.SqlAnalyzerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceContext {
    private static final ThreadLocal<ResourceContext> threadLocal = new ThreadLocal();
    protected DBDef _currentDBDef;
    protected DBMetaProvider _dbmetaProvider;
    protected SqlClauseCreator _sqlClauseCreator;
    protected ResourceParameter _resourceParameter;
    protected SqlAnalyzerFactory _sqlAnalyzerFactory;

    public static ResourceContext getResourceContextOnThread() {
        return threadLocal.get();
    }

    public static void setResourceContextOnThread(ResourceContext resourceCountext) {
        threadLocal.set(resourceCountext);
    }

    public static boolean isExistResourceContextOnThread() {
        return threadLocal.get() != null;
    }

    public static void clearResourceContextOnThread() {
        threadLocal.set(null);
    }

    public static DBDef currentDBDef() {
        if (!ResourceContext.isExistResourceContextOnThread()) {
            return DBDef.Unknown;
        }
        DBDef currentDBDef = ResourceContext.getResourceContextOnThread().getCurrentDBDef();
        if (currentDBDef == null) {
            return DBDef.Unknown;
        }
        return currentDBDef;
    }

    public static boolean isCurrentDBDef(DBDef targetDBDef) {
        return ResourceContext.currentDBDef().equals((Object)targetDBDef);
    }

    public static DBMetaProvider dbmetaProvider() {
        if (!ResourceContext.isExistResourceContextOnThread()) {
            String msg = "The resource context should exist!";
            throw new IllegalStateException(msg);
        }
        DBMetaProvider provider = ResourceContext.getResourceContextOnThread().getDBMetaProvider();
        if (provider == null) {
            String msg = "The provider of DB meta should exist!";
            throw new IllegalStateException(msg);
        }
        return provider;
    }

    public static DBMeta provideDBMeta(String tableFlexibleName) {
        if (!ResourceContext.isExistResourceContextOnThread()) {
            return null;
        }
        DBMetaProvider provider = ResourceContext.getResourceContextOnThread().getDBMetaProvider();
        if (provider == null) {
            return null;
        }
        return provider.provideDBMeta(tableFlexibleName);
    }

    public static DBMeta provideDBMetaChecked(String tableFlexibleName) {
        if (!ResourceContext.isExistResourceContextOnThread()) {
            String msg = "The resource context should exist: " + tableFlexibleName;
            throw new IllegalStateException(msg);
        }
        DBMetaProvider provider = ResourceContext.getResourceContextOnThread().getDBMetaProvider();
        if (provider == null) {
            String msg = "The provider of DB meta should exist: " + tableFlexibleName;
            throw new IllegalStateException(msg);
        }
        return provider.provideDBMetaChecked(tableFlexibleName);
    }

    public static SqlAnalyzer createSqlAnalyzer(String sql, boolean blockNullParameter) {
        if (!ResourceContext.isExistResourceContextOnThread()) {
            String msg = "The resource context should exist!";
            throw new IllegalStateException(msg);
        }
        SqlAnalyzerFactory factory = ResourceContext.getResourceContextOnThread().getSqlAnalyzerFactory();
        if (factory == null) {
            String msg = "The provider of SQL analyzer should exist!";
            throw new IllegalStateException(msg);
        }
        return factory.create(sql, blockNullParameter);
    }

    public static boolean isUniqueConstraintException(String sqlState, Integer errorCode) {
        if (!ResourceContext.isExistResourceContextOnThread()) {
            return false;
        }
        SqlClauseCreator sqlClauseCreator = ResourceContext.getResourceContextOnThread().getSqlClauseCreator();
        if (sqlClauseCreator == null) {
            return false;
        }
        return ResourceContext.currentDBDef().dbway().isUniqueConstraintException(sqlState, errorCode);
    }

    public static String getOutsideSqlPackage() {
        ResourceParameter resourceParameter = ResourceContext.resourceParameter();
        if (resourceParameter == null) {
            return null;
        }
        return resourceParameter.getOutsideSqlPackage();
    }

    public static String getLogDateFormat() {
        ResourceParameter resourceParameter = ResourceContext.resourceParameter();
        if (resourceParameter == null) {
            return null;
        }
        return resourceParameter.getLogDateFormat();
    }

    public static String getLogTimestampFormat() {
        ResourceParameter resourceParameter = ResourceContext.resourceParameter();
        if (resourceParameter == null) {
            return null;
        }
        return resourceParameter.getLogTimestampFormat();
    }

    protected static ResourceParameter resourceParameter() {
        if (!ResourceContext.isExistResourceContextOnThread()) {
            return null;
        }
        ResourceParameter resourceParameter = ResourceContext.getResourceContextOnThread().getResourceParameter();
        if (resourceParameter == null) {
            return null;
        }
        return resourceParameter;
    }

    public static Date getAccessDate() {
        return AccessContext.getAccessDateOnThread();
    }

    public static Timestamp getAccessTimestamp() {
        return AccessContext.getAccessTimestampOnThread();
    }

    public static Set<String> createSelectColumnNames(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int count = rsmd.getColumnCount();
        StringSet columnNames = StringSet.createAsCaseInsensitive();
        for (int i = 0; i < count; ++i) {
            String columnName = rsmd.getColumnLabel(i + 1);
            int pos = columnName.lastIndexOf(46);
            if (-1 < pos) {
                columnNames.add(columnName.substring(pos + 1));
                continue;
            }
            columnNames.add(columnName);
        }
        Map<String, Integer> selectIndexMap = ResourceContext.getSelectIndexMap();
        if (selectIndexMap == null) {
            return columnNames;
        }
        Map<String, String> selectIndexReverseMap = ResourceContext.getSelectIndexReverseMap();
        StringSet realColumnNames = StringSet.createAsCaseInsensitive();
        for (String columnName : columnNames) {
            String uniqueName = selectIndexReverseMap.get(columnName);
            if (uniqueName != null) {
                realColumnNames.add(uniqueName);
                continue;
            }
            realColumnNames.add(columnName);
        }
        return realColumnNames;
    }

    public static Map<String, Integer> getSelectIndexMap() {
        if (!ConditionBeanContext.isExistConditionBeanOnThread()) {
            return null;
        }
        ConditionBean cb = ConditionBeanContext.getConditionBeanOnThread();
        if (cb == null) {
            return null;
        }
        return cb.getSqlClause().getSelectIndexMap();
    }

    protected static Map<String, String> getSelectIndexReverseMap() {
        if (!ConditionBeanContext.isExistConditionBeanOnThread()) {
            return null;
        }
        ConditionBean cb = ConditionBeanContext.getConditionBeanOnThread();
        if (cb == null) {
            return null;
        }
        return cb.getSqlClause().getSelectIndexReverseMap();
    }

    public static Object getValue(ResultSet rs, String columnName, ValueType valueType, Map<String, Integer> selectIndexMap) throws SQLException {
        Integer selectIndex = selectIndexMap.get(columnName);
        if (selectIndex != null) {
            return valueType.getValue(rs, (int)selectIndex);
        }
        return valueType.getValue(rs, columnName);
    }

    public DBDef getCurrentDBDef() {
        return this._currentDBDef;
    }

    public void setCurrentDBDef(DBDef currentDBDef) {
        this._currentDBDef = currentDBDef;
    }

    public DBMetaProvider getDBMetaProvider() {
        return this._dbmetaProvider;
    }

    public void setDBMetaProvider(DBMetaProvider dbmetaProvider) {
        this._dbmetaProvider = dbmetaProvider;
    }

    public SqlClauseCreator getSqlClauseCreator() {
        return this._sqlClauseCreator;
    }

    public void setSqlClauseCreator(SqlClauseCreator sqlClauseCreator) {
        this._sqlClauseCreator = sqlClauseCreator;
    }

    public ResourceParameter getResourceParameter() {
        return this._resourceParameter;
    }

    public void setResourceParameter(ResourceParameter resourceParameter) {
        this._resourceParameter = resourceParameter;
    }

    public SqlAnalyzerFactory getSqlAnalyzerFactory() {
        return this._sqlAnalyzerFactory;
    }

    public void setSqlAnalyzerFactory(SqlAnalyzerFactory sqlAnalyzerFactory) {
        this._sqlAnalyzerFactory = sqlAnalyzerFactory;
    }
}

