/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.bhv.core;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.seasar.robot.dbflute.CallbackContext;
import org.seasar.robot.dbflute.DBDef;
import org.seasar.robot.dbflute.Entity;
import org.seasar.robot.dbflute.XLog;
import org.seasar.robot.dbflute.bhv.core.BehaviorCommand;
import org.seasar.robot.dbflute.bhv.core.BehaviorCommandComponentSetup;
import org.seasar.robot.dbflute.bhv.core.InvokerAssistant;
import org.seasar.robot.dbflute.bhv.core.SqlExecution;
import org.seasar.robot.dbflute.bhv.core.SqlExecutionCreator;
import org.seasar.robot.dbflute.bhv.outsidesql.OutsideSqlBasicExecutor;
import org.seasar.robot.dbflute.cbean.ConditionBeanContext;
import org.seasar.robot.dbflute.cbean.FetchAssistContext;
import org.seasar.robot.dbflute.cbean.FetchNarrowingBean;
import org.seasar.robot.dbflute.dbmeta.DBMeta;
import org.seasar.robot.dbflute.helper.stacktrace.InvokeNameExtractingResource;
import org.seasar.robot.dbflute.helper.stacktrace.InvokeNameResult;
import org.seasar.robot.dbflute.helper.stacktrace.impl.InvokeNameExtractorImpl;
import org.seasar.robot.dbflute.jdbc.SqlResultHandler;
import org.seasar.robot.dbflute.jdbc.SqlResultInfo;
import org.seasar.robot.dbflute.jdbc.StatementConfig;
import org.seasar.robot.dbflute.outsidesql.OutsideSqlContext;
import org.seasar.robot.dbflute.resource.InternalMapContext;
import org.seasar.robot.dbflute.resource.ResourceContext;
import org.seasar.robot.dbflute.util.DfSystemUtil;
import org.seasar.robot.dbflute.util.DfTraceViewUtil;
import org.seasar.robot.dbflute.util.DfTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BehaviorCommandInvoker {
    protected InvokerAssistant _invokerAssistant;
    protected final Map<String, SqlExecution> _executionMap = new ConcurrentHashMap<String, SqlExecution>();

    public void clearExecutionCache() {
        this._executionMap.clear();
    }

    public boolean isExecutionCacheEmpty() {
        return this._executionMap.isEmpty();
    }

    public int getExecutionCacheSize() {
        return this._executionMap.size();
    }

    public void injectComponentProperty(BehaviorCommandComponentSetup behaviorCommand) {
        this.assertInvokerAssistant();
        behaviorCommand.setDataSource(this._invokerAssistant.assistDataSource());
        behaviorCommand.setStatementFactory(this._invokerAssistant.assistStatementFactory());
        behaviorCommand.setBeanMetaDataFactory(this._invokerAssistant.assistBeanMetaDataFactory());
        behaviorCommand.setValueTypeFactory(this._invokerAssistant.assistValueTypeFactory());
        behaviorCommand.setSqlFileEncoding(this.getSqlFileEncoding());
    }

    protected String getSqlFileEncoding() {
        this.assertInvokerAssistant();
        return this._invokerAssistant.assistSqlFileEncoding();
    }

    public OutsideSqlBasicExecutor createOutsideSqlBasicExecutor(String tableDbName) {
        DBDef dbDef = this._invokerAssistant.assistCurrentDBDef();
        StatementConfig statementConfig = this._invokerAssistant.assistDefaultStatementConfig();
        return new OutsideSqlBasicExecutor(this, tableDbName, dbDef, statementConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RESULT> RESULT invoke(BehaviorCommand<RESULT> behaviorCommand) {
        this.clearContext();
        try {
            RESULT RESULT = this.dispatchInvoking(behaviorCommand);
            return RESULT;
        }
        finally {
            this.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <RESULT> RESULT dispatchInvoking(BehaviorCommand<RESULT> behaviorCommand) {
        this.setupResourceContext();
        boolean logEnabled = this.isLogEnabled();
        if (behaviorCommand.isInitializeOnly()) {
            this.initializeSqlExecution(behaviorCommand);
            return null;
        }
        behaviorCommand.beforeGettingSqlExecution();
        SqlExecution execution = this.findSqlExecution(behaviorCommand);
        SqlResultHandler sqlResultHander = this.getSqlResultHander();
        boolean existsSqlResultHandler = sqlResultHander != null;
        long before = this.deriveCommandBeforeAfterTimeIfNeeds(logEnabled, existsSqlResultHandler);
        Object ret = null;
        try {
            Object[] args = behaviorCommand.getSqlExecutionArgument();
            ret = this.executeSql(execution, args);
        }
        finally {
            behaviorCommand.afterExecuting();
        }
        Class<?> retType = behaviorCommand.getCommandReturnType();
        this.assertRetType(retType, ret);
        long after = this.deriveCommandBeforeAfterTimeIfNeeds(logEnabled, existsSqlResultHandler);
        if (logEnabled) {
            this.logReturn(behaviorCommand, retType, ret, before, after);
        }
        if (retType.isPrimitive()) {
            ret = this.convertPrimitiveWrapper(retType, ret);
        } else if (Number.class.isAssignableFrom(retType)) {
            ret = this.convertNumber(retType, ret);
        }
        this.callbackSqlResultHanler(behaviorCommand, existsSqlResultHandler, sqlResultHander, ret, before, after);
        Object result = ret;
        return (RESULT)result;
    }

    protected void setupResourceContext() {
        this.assertInvokerAssistant();
        ResourceContext resourceContext = new ResourceContext();
        resourceContext.setCurrentDBDef(this._invokerAssistant.assistCurrentDBDef());
        resourceContext.setDBMetaProvider(this._invokerAssistant.assistDBMetaProvider());
        resourceContext.setSqlClauseCreator(this._invokerAssistant.assistSqlClauseCreator());
        resourceContext.setSqlAnalyzerFactory(this._invokerAssistant.assistSqlAnalyzerFactory());
        resourceContext.setResourceParameter(this._invokerAssistant.assistResourceParameter());
        ResourceContext.setResourceContextOnThread(resourceContext);
    }

    protected long deriveCommandBeforeAfterTimeIfNeeds(boolean logEnabled, boolean existsSqlResultHandler) {
        long time = 0L;
        if (logEnabled || existsSqlResultHandler) {
            time = this.systemTime();
        }
        return time;
    }

    protected long systemTime() {
        return System.currentTimeMillis();
    }

    protected <RESULT> void callbackSqlResultHanler(BehaviorCommand<RESULT> behaviorCommand, boolean existsSqlResultHandler, SqlResultHandler sqlResultHander, Object ret, long before, long after) {
        if (existsSqlResultHandler) {
            String displaySql = (String)InternalMapContext.getObject("df:DisplaySql");
            SqlResultInfo info = new SqlResultInfo();
            info.setResult(ret);
            info.setTableDbName(behaviorCommand.getTableDbName());
            info.setCommandName(behaviorCommand.getCommandName());
            info.setDisplaySql(displaySql);
            info.setBeforeTimeMillis(before);
            info.setAfterTimeMillis(after);
            sqlResultHander.handle(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <RESULT> SqlExecution findSqlExecution(BehaviorCommand<RESULT> behaviorCommand) {
        boolean logEnabled = this.isLogEnabled();
        SqlExecution execution = null;
        try {
            String key = behaviorCommand.buildSqlExecutionKey();
            execution = this.getSqlExecution(key);
            if (execution == null) {
                long afterCmd;
                long beforeCmd = 0L;
                if (logEnabled) {
                    beforeCmd = this.systemTime();
                }
                SqlExecutionCreator creator = behaviorCommand.createSqlExecutionCreator();
                execution = this.getSqlExecution(key, creator);
                if (logEnabled && beforeCmd != (afterCmd = this.systemTime())) {
                    this.logSqlExecution(behaviorCommand, execution, beforeCmd, afterCmd);
                }
            }
            SqlExecution sqlExecution = execution;
            return sqlExecution;
        }
        finally {
            if (logEnabled) {
                this.logInvocation(behaviorCommand);
            }
        }
    }

    protected <RESULT> void initializeSqlExecution(BehaviorCommand<RESULT> behaviorCommand) {
        String key = behaviorCommand.buildSqlExecutionKey();
        SqlExecutionCreator creator = behaviorCommand.createSqlExecutionCreator();
        this.getSqlExecution(key, creator);
    }

    protected SqlExecution getSqlExecution(String key) {
        return this._executionMap.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SqlExecution getSqlExecution(String key, SqlExecutionCreator executionCreator) {
        SqlExecution execution = this.getSqlExecution(key);
        if (execution != null) {
            return execution;
        }
        Map<String, SqlExecution> map = this._executionMap;
        synchronized (map) {
            execution = this.getSqlExecution(key);
            if (execution != null) {
                if (this.isLogEnabled()) {
                    this.log("...Getting sqlExecution as cache because the previous thread have already initialized.");
                }
                return execution;
            }
            if (this.isLogEnabled()) {
                this.log("...Initializing sqlExecution for the key '" + key + "'");
            }
            this._executionMap.put(key, executionCreator.createSqlExecution());
        }
        execution = this.getSqlExecution(key);
        if (execution == null) {
            String msg = "sqlExecutionCreator.createSqlCommand() should not return null:";
            msg = msg + " sqlExecutionCreator=" + executionCreator + " key=" + key;
            throw new IllegalStateException(msg);
        }
        this.toBeDisposable();
        return execution;
    }

    protected Object executeSql(SqlExecution execution, Object[] args) {
        return execution.execute(args);
    }

    protected <RESULT> void logSqlExecution(BehaviorCommand<RESULT> behaviorCommand, SqlExecution execution, long beforeCmd, long afterCmd) {
        this.log("SqlExecution Initialization Cost: [" + DfTraceViewUtil.convertToPerformanceView(afterCmd - beforeCmd) + "]");
    }

    protected <RESULT> void logInvocation(BehaviorCommand<RESULT> behaviorCommand) {
        OutsideSqlContext outsideSqlContext;
        String invokeMethodName;
        String invokeClassName;
        InvokeNameResult headBehaviorResult;
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        List<InvokeNameResult> behaviorResultList = this.extractBehaviorInvoke(stackTrace);
        this.filterBehaviorResult(behaviorCommand, behaviorResultList);
        if (!behaviorResultList.isEmpty()) {
            headBehaviorResult = this.findHeadInvokeResult(behaviorResultList);
            invokeClassName = headBehaviorResult.getSimpleClassName();
            invokeMethodName = headBehaviorResult.getMethodName();
        } else {
            headBehaviorResult = null;
            invokeClassName = behaviorCommand.getTableDbName();
            invokeMethodName = behaviorCommand.getCommandName();
        }
        String expWithoutKakko = this.buildInvocationExpressionWithoutKakko(behaviorCommand, invokeClassName, invokeMethodName);
        this.putObjectToMapContext("df:BehaviorInvokeName", expWithoutKakko + "()");
        String equalBorder = this.buildFitBorder("", "=", expWithoutKakko, false);
        String callerExpression = expWithoutKakko + "()";
        String frameBase = "/=====================================================";
        String spaceBase = "                                                      ";
        this.log("/=====================================================" + equalBorder + "==");
        this.log("                                                      " + callerExpression);
        this.log("                                                      " + equalBorder + "=/");
        String invokePath = this.buildInvokePath(behaviorCommand, stackTrace, headBehaviorResult);
        this.log(invokePath);
        if (behaviorCommand.isOutsideSql() && !behaviorCommand.isProcedure() && (outsideSqlContext = this.getOutsideSqlContext()) != null) {
            this.log("path: " + behaviorCommand.getOutsideSqlPath());
            this.log("option: " + behaviorCommand.getOutsideSqlOption());
        }
    }

    protected <RESULT> void filterBehaviorResult(BehaviorCommand<RESULT> behaviorCommand, List<InvokeNameResult> behaviorResultList) {
        for (InvokeNameResult behaviorResult : behaviorResultList) {
            String simpleClassName = behaviorResult.getSimpleClassName();
            if (simpleClassName == null) {
                return;
            }
            if (!simpleClassName.contains("Behavior") || !simpleClassName.endsWith("$SLFunction")) continue;
            String behaviorClassName = this.findBehaviorClassNameFromDBMeta(behaviorCommand.getTableDbName());
            behaviorResult.setSimpleClassName(behaviorClassName);
            behaviorResult.setMethodName("scalarSelect()." + behaviorResult.getMethodName());
        }
    }

    protected <RESULT> String buildInvokePath(BehaviorCommand<RESULT> behaviorCommand, StackTraceElement[] stackTrace, InvokeNameResult behaviorResult) {
        String byPassInvokeName;
        int bhvNextIndex = behaviorResult != null ? behaviorResult.getNextStartIndex() : -1;
        List<InvokeNameResult> clientResultList = this.extractClientInvoke(stackTrace, bhvNextIndex);
        InvokeNameResult headClientResult = this.findHeadInvokeResult(clientResultList);
        int clientFirstIndex = headClientResult != null ? headClientResult.getFoundFirstIndex() : -1;
        int byPassLoopSize = clientFirstIndex - bhvNextIndex;
        List<InvokeNameResult> byPassResultList = this.extractByPassInvoke(stackTrace, bhvNextIndex, byPassLoopSize);
        InvokeNameResult headByPassResult = this.findHeadInvokeResult(byPassResultList);
        if (headClientResult == null && headByPassResult == null) {
            return null;
        }
        String clientInvokeName = headClientResult != null ? headClientResult.getInvokeName() : "";
        String string = byPassInvokeName = headByPassResult != null ? headByPassResult.getInvokeName() : "";
        if (clientInvokeName.trim().length() > 0) {
            this.putObjectToMapContext("df:ClientInvokeName", clientInvokeName);
        }
        if (byPassInvokeName.trim().length() > 0) {
            this.putObjectToMapContext("df:ByPassInvokeName", byPassInvokeName);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(clientInvokeName);
        sb.append(this.findTailInvokeName(clientResultList));
        sb.append(byPassInvokeName);
        sb.append(this.findTailInvokeName(byPassResultList));
        sb.append("...");
        return sb.toString();
    }

    protected InvokeNameResult findHeadInvokeResult(List<InvokeNameResult> resultList) {
        if (!resultList.isEmpty()) {
            return resultList.get(resultList.size() - 1);
        }
        return null;
    }

    protected String findTailInvokeName(List<InvokeNameResult> resultList) {
        if (resultList.size() > 1) {
            return resultList.get(0).getInvokeName();
        }
        return "";
    }

    protected <RESULT> String buildInvocationExpressionWithoutKakko(BehaviorCommand<RESULT> behaviorCommand, String invokeClassName, String invokeMethodName) {
        if (invokeClassName.contains("OutsideSql") && invokeClassName.endsWith("Executor")) {
            try {
                String originalName = invokeClassName;
                if (behaviorCommand.isOutsideSql()) {
                    OutsideSqlContext outsideSqlContext = this.getOutsideSqlContext();
                    String tableDbName = outsideSqlContext.getTableDbName();
                    String behaviorClassName = this.findBehaviorClassNameFromDBMeta(tableDbName);
                    invokeClassName = behaviorClassName + ".outsideSql()";
                    if (originalName.endsWith("OutsideSqlEntityExecutor")) {
                        invokeClassName = invokeClassName + ".entityHandling()";
                    } else if (originalName.endsWith("OutsideSqlPagingExecutor")) {
                        invokeClassName = outsideSqlContext.isAutoPagingLogging() ? invokeClassName + ".autoPaging()" : invokeClassName + ".manualPaging()";
                    } else if (originalName.endsWith("OutsideSqlCursorExecutor")) {
                        invokeClassName = invokeClassName + ".cursorHandling()";
                    }
                } else {
                    invokeClassName = "OutsideSql";
                }
            }
            catch (RuntimeException ignored) {
                this.log("Ignored exception occurred: msg=" + ignored.getMessage());
            }
        }
        String callerExpressionWithoutKakko = invokeClassName + "." + invokeMethodName;
        if ("selectPage".equals(invokeMethodName)) {
            OutsideSqlContext outsideSqlContext;
            Class<?> resultType;
            boolean resultTypeInteger = false;
            if (behaviorCommand.isOutsideSql() && (resultType = (outsideSqlContext = this.getOutsideSqlContext()).getResultType()) != null && Integer.class.isAssignableFrom(resultType)) {
                resultTypeInteger = true;
            }
            callerExpressionWithoutKakko = resultTypeInteger || behaviorCommand.isSelectCount() ? callerExpressionWithoutKakko + "():count" : callerExpressionWithoutKakko + "():paging";
        }
        return callerExpressionWithoutKakko;
    }

    protected String buildFitBorder(String prefix, String element, String lengthTargetString, boolean space) {
        int length = space ? lengthTargetString.length() / 2 : lengthTargetString.length();
        StringBuffer sb = new StringBuffer();
        sb.append(prefix);
        for (int i = 0; i < length; ++i) {
            sb.append(element);
            if (!space) continue;
            sb.append(" ");
        }
        if (space) {
            sb.append(element);
        }
        return sb.toString();
    }

    protected List<InvokeNameResult> extractClientInvoke(StackTraceElement[] stackTrace, final int startIndex) {
        String[] names = new String[]{"Page", "Action", "Test"};
        final List<String> suffixList = Arrays.asList(names);
        InvokeNameExtractingResource resource = new InvokeNameExtractingResource(){

            public boolean isTargetElement(String className, String methodName) {
                return BehaviorCommandInvoker.this.isClassNameEndsWith(className, suffixList);
            }

            public String filterSimpleClassName(String simpleClassName) {
                return simpleClassName;
            }

            public boolean isUseAdditionalInfo() {
                return true;
            }

            public int getStartIndex() {
                return startIndex;
            }

            public int getLoopSize() {
                return 25;
            }
        };
        return this.extractInvokeName(resource, stackTrace);
    }

    protected List<InvokeNameResult> extractByPassInvoke(StackTraceElement[] stackTrace, final int startIndex, final int loopSize) {
        String[] names = new String[]{"Service", "ServiceImpl", "Facade", "FacadeImpl", "Logic", "LogicImpl"};
        final List<String> suffixList = Arrays.asList(names);
        InvokeNameExtractingResource resource = new InvokeNameExtractingResource(){

            public boolean isTargetElement(String className, String methodName) {
                return BehaviorCommandInvoker.this.isClassNameEndsWith(className, suffixList);
            }

            public String filterSimpleClassName(String simpleClassName) {
                return simpleClassName;
            }

            public boolean isUseAdditionalInfo() {
                return true;
            }

            public int getStartIndex() {
                return startIndex;
            }

            public int getLoopSize() {
                return loopSize >= 0 ? loopSize : 25;
            }
        };
        return this.extractInvokeName(resource, stackTrace);
    }

    protected List<InvokeNameResult> extractBehaviorInvoke(StackTraceElement[] stackTrace) {
        String[] names = new String[]{"Bhv", "BehaviorReadable", "BehaviorWritable", "PagingInvoker"};
        final List<String> suffixList = Arrays.asList(names);
        final List<String> keywordList = Arrays.asList("Bhv$", "BehaviorReadable$", "BehaviorWritable$");
        final List<String> ousideSql1List = Arrays.asList("OutsideSql");
        final List<String> ousideSql2List = Arrays.asList("Executor");
        final List<String> ousideSql3List = Arrays.asList("Executor$");
        InvokeNameExtractingResource resource = new InvokeNameExtractingResource(){

            public boolean isTargetElement(String className, String methodName) {
                if (BehaviorCommandInvoker.this.isClassNameEndsWith(className, suffixList)) {
                    return true;
                }
                if (BehaviorCommandInvoker.this.isClassNameContains(className, keywordList)) {
                    return true;
                }
                return BehaviorCommandInvoker.this.isClassNameContains(className, ousideSql1List) && (BehaviorCommandInvoker.this.isClassNameEndsWith(className, ousideSql2List) || BehaviorCommandInvoker.this.isClassNameContains(className, ousideSql3List));
            }

            public String filterSimpleClassName(String simpleClassName) {
                return BehaviorCommandInvoker.this.removeBasePrefixFromSimpleClassName(simpleClassName);
            }

            public boolean isUseAdditionalInfo() {
                return false;
            }

            public int getStartIndex() {
                return 0;
            }

            public int getLoopSize() {
                return 25;
            }
        };
        return this.extractInvokeName(resource, stackTrace);
    }

    protected boolean isClassNameEndsWith(String className, List<String> suffixList) {
        for (String suffix : suffixList) {
            if (!className.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    protected boolean isClassNameContains(String className, List<String> keywordList) {
        for (String keyword : keywordList) {
            if (!className.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    protected List<InvokeNameResult> extractInvokeName(InvokeNameExtractingResource resource, StackTraceElement[] stackTrace) {
        InvokeNameExtractorImpl extractor = new InvokeNameExtractorImpl();
        extractor.setStackTrace(stackTrace);
        return extractor.extractInvokeName(resource);
    }

    protected String removeBasePrefixFromSimpleClassName(String simpleClassName) {
        if (!simpleClassName.startsWith("Bs")) {
            return simpleClassName;
        }
        int prefixLength = "Bs".length();
        if (!Character.isUpperCase(simpleClassName.substring(prefixLength).charAt(0))) {
            return simpleClassName;
        }
        if (simpleClassName.length() <= prefixLength) {
            return simpleClassName;
        }
        return "" + simpleClassName.substring(prefixLength);
    }

    protected String findBehaviorClassNameFromDBMeta(String tableDbName) {
        DBMeta dbmeta = ResourceContext.provideDBMetaChecked(tableDbName);
        String behaviorTypeName = dbmeta.getBehaviorTypeName();
        String behaviorClassName = behaviorTypeName.substring(behaviorTypeName.lastIndexOf(".") + ".".length());
        return this.removeBasePrefixFromSimpleClassName(behaviorClassName);
    }

    protected <RESULT> void logReturn(BehaviorCommand<RESULT> behaviorCommand, Class<?> retType, Object ret, long before, long after) {
        try {
            String prefix = "===========/ [" + DfTraceViewUtil.convertToPerformanceView(after - before) + " ";
            if (List.class.isAssignableFrom(retType)) {
                if (ret == null) {
                    this.log(prefix + "(null)]");
                } else {
                    List ls = (List)ret;
                    if (ls.isEmpty()) {
                        this.log(prefix + "(0)]");
                    } else if (ls.size() == 1) {
                        this.log(prefix + "(1) result=" + this.buildResultString(ls.get(0)) + "]");
                    } else {
                        this.log(prefix + "(" + ls.size() + ") first=" + this.buildResultString(ls.get(0)) + "]");
                    }
                }
            } else if (Entity.class.isAssignableFrom(retType)) {
                if (ret == null) {
                    this.log(prefix + "(null)" + "]");
                } else {
                    Entity entity = (Entity)ret;
                    this.log(prefix + "(1) result=" + this.buildResultString(entity) + "]");
                }
            } else if (int[].class.isAssignableFrom(retType)) {
                if (ret == null) {
                    this.log(prefix + "(null)" + "]");
                } else {
                    int[] resultArray = (int[])ret;
                    if (resultArray.length == 0) {
                        this.log(prefix + "all-updated=(0)]");
                    } else {
                        StringBuilder sb = new StringBuilder();
                        boolean resultExpressionScope = true;
                        int resultCount = 0;
                        int loopCount = 0;
                        for (int element : resultArray) {
                            resultCount += element;
                            if (resultExpressionScope) {
                                if (loopCount <= 10) {
                                    if (sb.length() == 0) {
                                        sb.append(element);
                                    } else {
                                        sb.append(",").append(element);
                                    }
                                } else {
                                    sb.append(",").append("...");
                                    resultExpressionScope = false;
                                }
                            }
                            ++loopCount;
                        }
                        sb.insert(0, "{").append("}");
                        this.log(prefix + "all-updated=(" + resultCount + ") result=" + sb + "]");
                    }
                }
            } else {
                this.log(prefix + "result=" + ret + "]");
            }
            this.log(" ");
        }
        catch (RuntimeException e) {
            String msg = "Result object debug threw the exception: behaviorCommand=";
            msg = msg + behaviorCommand + " retType=" + retType;
            msg = msg + " ret=" + ret;
            throw e;
        }
    }

    protected String buildResultString(Object obj) {
        if (obj instanceof Entity) {
            Entity entity = (Entity)obj;
            return entity.buildDisplayString(null, true, true);
        }
        return obj != null ? obj.toString() : "null";
    }

    protected OutsideSqlContext getOutsideSqlContext() {
        if (!OutsideSqlContext.isExistOutsideSqlContextOnThread()) {
            return null;
        }
        return OutsideSqlContext.getOutsideSqlContextOnThread();
    }

    protected SqlResultHandler getSqlResultHander() {
        if (!CallbackContext.isExistCallbackContextOnThread()) {
            return null;
        }
        return CallbackContext.getCallbackContextOnThread().getSqlResultHandler();
    }

    protected void putObjectToMapContext(String key, Object value) {
        InternalMapContext.setObject(key, value);
    }

    protected void clearContext() {
        if (OutsideSqlContext.isExistOutsideSqlContextOnThread()) {
            OutsideSqlContext.clearOutsideSqlContextOnThread();
        }
        if (FetchAssistContext.isExistFetchBeanOnThread()) {
            if (FetchAssistContext.isExistFetchNarrowingBeanOnThread()) {
                FetchNarrowingBean fnbean = FetchAssistContext.getFetchNarrowingBeanOnThread();
                fnbean.restoreIgnoredFetchNarrowing();
            }
            FetchAssistContext.clearFetchBeanOnThread();
        }
        if (ConditionBeanContext.isExistConditionBeanOnThread()) {
            ConditionBeanContext.clearConditionBeanOnThread();
        }
        if (ConditionBeanContext.isExistEntityRowHandlerOnThread()) {
            ConditionBeanContext.clearEntityRowHandlerOnThread();
        }
        if (InternalMapContext.isExistInternalMapContextOnThread()) {
            InternalMapContext.clearInternalMapContextOnThread();
        }
        if (ResourceContext.isExistResourceContextOnThread()) {
            ResourceContext.clearResourceContextOnThread();
        }
    }

    protected void log(String msg) {
        XLog.log(msg);
    }

    protected boolean isLogEnabled() {
        return XLog.isLogEnabled();
    }

    protected void toBeDisposable() {
        this.assertInvokerAssistant();
        this._invokerAssistant.toBeDisposable();
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    protected Object convertPrimitiveWrapper(Class<?> retType, Object ret) {
        return DfTypeUtil.toWrapper(retType, ret);
    }

    protected Object convertNumber(Class<?> retType, Object ret) {
        return DfTypeUtil.toNumber(retType, ret);
    }

    protected void assertRetType(Class<?> retType, Object ret) {
        if (List.class.isAssignableFrom(retType)) {
            if (ret != null && !(ret instanceof List)) {
                String msg = "The retType is difference from actual return: ";
                msg = msg + "retType=" + retType + " ret.getClass()=" + ret.getClass() + " ref=" + ret;
                throw new IllegalStateException(msg);
            }
        } else if (Entity.class.isAssignableFrom(retType) && ret != null && !(ret instanceof Entity)) {
            String msg = "The retType is difference from actual return: ";
            msg = msg + "retType=" + retType + " ret.getClass()=" + ret.getClass() + " ref=" + ret;
            throw new IllegalStateException(msg);
        }
    }

    protected void assertInvokerAssistant() {
        if (this._invokerAssistant == null) {
            String msg = "The attribute 'invokerAssistant' should not be null!";
            throw new IllegalStateException(msg);
        }
    }

    public void setInvokerAssistant(InvokerAssistant invokerAssistant) {
        this._invokerAssistant = invokerAssistant;
    }
}

