/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.sax.SafeContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XHTMLContentHandler
extends SafeContentHandler {
    public static final String XHTML = "http://www.w3.org/1999/xhtml";
    private static final char[] NL = new char[]{'\n'};
    private static final char[] TAB = new char[]{'\t'};
    private static final Set<String> INDENT = XHTMLContentHandler.unmodifiableSet("li", "dd", "dt", "td", "th");
    public static final Set<String> ENDLINE = XHTMLContentHandler.unmodifiableSet("p", "h1", "h2", "h3", "h4", "h5", "h6", "div", "ul", "ol", "dl", "pre", "hr", "blockquote", "address", "fieldset", "table", "form", "noscript", "li", "dt", "dd", "noframes", "br", "tr");
    private final Metadata metadata;
    private boolean started = false;

    private static Set<String> unmodifiableSet(String ... elements) {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(elements)));
    }

    public XHTMLContentHandler(ContentHandler handler, Metadata metadata) {
        super(handler);
        this.metadata = metadata;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.startPrefixMapping("", XHTML);
    }

    private void lazyStartDocument() throws SAXException {
        if (!this.started) {
            this.started = true;
            this.startElement("html");
            this.startElement("head");
            this.startElement("title");
            String title = this.metadata.get("title");
            if (title != null && title.length() > 0) {
                this.characters(title);
            }
            this.endElement("title");
            this.endElement("head");
            this.startElement("body");
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.lazyStartDocument();
        this.endElement("body");
        this.endElement("html");
        this.endPrefixMapping("");
        super.endDocument();
    }

    @Override
    public void startElement(String uri, String local, String name, Attributes attributes) throws SAXException {
        this.lazyStartDocument();
        if (XHTML.equals(uri) && INDENT.contains(local)) {
            this.ignorableWhitespace(TAB, 0, TAB.length);
        }
        super.startElement(uri, local, name, attributes);
    }

    @Override
    public void endElement(String uri, String local, String name) throws SAXException {
        super.endElement(uri, local, name);
        if (XHTML.equals(uri) && ENDLINE.contains(local)) {
            this.newline();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lazyStartDocument();
        super.characters(ch, start, length);
    }

    public void startElement(String name) throws SAXException {
        this.startElement(XHTML, name, name, new AttributesImpl());
    }

    public void startElement(String name, String attribute, String value) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", attribute, attribute, "CDATA", value);
        this.startElement(XHTML, name, name, attributes);
    }

    public void endElement(String name) throws SAXException {
        this.endElement(XHTML, name, name);
    }

    public void characters(String characters) throws SAXException {
        this.characters(characters.toCharArray(), 0, characters.length());
    }

    public void newline() throws SAXException {
        this.ignorableWhitespace(NL, 0, NL.length);
    }

    public void element(String name, String value) throws SAXException {
        this.startElement(name);
        this.characters(value);
        this.endElement(name);
    }
}

