/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.xml;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mobylet.core.util.ObjectUtils;
import org.mobylet.core.util.StringUtils;

public class XmlNode {
    private static final long serialVersionUID = -2224946250718469933L;
    private static final Pattern VAL_PATTERN = Pattern.compile("[^@]+\\(.+\\)");
    private static final Pattern ATT_PATTERN = Pattern.compile(".+@.+\\(.+\\)");
    protected String name;
    protected String value;
    protected Map<String, String> attributes;
    protected List<XmlNode> children;
    protected XmlNode parent;

    public XmlNode(String name) {
        this.name = name;
        this.attributes = new LinkedHashMap<String, String>();
        this.children = new ArrayList<XmlNode>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public <T> T getValue(Class<T> clazz) {
        return (T)this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public List<XmlNode> getChildren() {
        return this.children;
    }

    public List<XmlNode> getChildren(String qname) {
        ArrayList<XmlNode> childList = new ArrayList<XmlNode>();
        for (XmlNode node : this.children) {
            if (!StringUtils.equals(node.getName(), qname)) continue;
            childList.add(node);
        }
        return childList;
    }

    public List<XmlNode> getChildrenByValue(String qname, Object value) {
        ArrayList<XmlNode> childList = new ArrayList<XmlNode>();
        for (XmlNode node : this.children) {
            if (!StringUtils.equals(node.getName(), qname) || !ObjectUtils.equals(node.getValue(), value)) continue;
            childList.add(node);
        }
        return childList;
    }

    public List<XmlNode> getChildrenByAttribute(String qname, String name, String value) {
        ArrayList<XmlNode> childList = new ArrayList<XmlNode>();
        for (XmlNode node : this.children) {
            if (!StringUtils.equals(node.getName(), qname) || !ObjectUtils.equals(node.getAttributes().get(name), value)) continue;
            childList.add(node);
        }
        return childList;
    }

    public void addChild(XmlNode child) {
        this.children.add(child);
    }

    public XmlNode getParent() {
        return this.parent;
    }

    public void setParent(XmlNode parent) {
        this.parent = parent;
    }

    public List<XmlNode> getNodeListByXPath(String xpath) {
        String[] pathes;
        ArrayList<XmlNode> nodeList = new ArrayList<XmlNode>();
        if (xpath == null) {
            return nodeList;
        }
        ArrayList<XmlNode> tempList = new ArrayList<XmlNode>();
        nodeList.add(this);
        for (String path : pathes = xpath.split("/")) {
            String qname;
            if (StringUtils.isEmpty(path = path.replaceAll("_\uff0f", "/"))) continue;
            tempList.clear();
            tempList.addAll(nodeList);
            nodeList.clear();
            Matcher valMatcher = VAL_PATTERN.matcher(path);
            Matcher attMatcher = ATT_PATTERN.matcher(path);
            if (valMatcher.matches()) {
                qname = path.substring(0, path.indexOf("("));
                String value = path.substring(path.indexOf("(") + 1, path.indexOf(")"));
                for (XmlNode node : tempList) {
                    nodeList.addAll(node.getChildrenByValue(qname, value));
                }
                continue;
            }
            if (attMatcher.matches()) {
                qname = path.substring(0, path.indexOf("@"));
                String name = path.substring(path.indexOf("@") + 1, path.indexOf("("));
                String value = path.substring(path.indexOf("(") + 1, path.indexOf(")"));
                for (XmlNode node : tempList) {
                    nodeList.addAll(node.getChildrenByAttribute(qname, name, value));
                }
                continue;
            }
            for (XmlNode node : tempList) {
                nodeList.addAll(node.getChildren(path));
            }
        }
        return nodeList;
    }
}

