/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.http.image;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mobylet.core.http.MobyletServletOutputStream;
import org.mobylet.core.image.ConnectionStream;
import org.mobylet.core.image.ImageCacheHelper;
import org.mobylet.core.image.ImageCodec;
import org.mobylet.core.image.ImageReader;
import org.mobylet.core.image.ImageScaler;
import org.mobylet.core.util.ImageUtils;
import org.mobylet.core.util.InputStreamUtils;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;

public class MobyletImageScaleServlet
extends HttpServlet {
    private static final long serialVersionUID = -8330083988206718597L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Object outStream;
        ConnectionStream imageConnectionStream;
        String path = req.getParameter("img");
        if (StringUtils.isEmpty(path)) {
            return;
        }
        ImageCodec codec = ImageUtils.getImageCodec(path);
        ImageReader imageReader = SingletonUtils.get(ImageReader.class);
        ImageScaler imageScaler = SingletonUtils.get(ImageScaler.class);
        ImageCacheHelper cacheHelper = SingletonUtils.get(ImageCacheHelper.class);
        boolean enableCache = cacheHelper.enableCache();
        path = imageReader.constructPath(path);
        String key = null;
        if (enableCache) {
            key = cacheHelper.getCacheKey(path);
            if (cacheHelper.existsCache(key)) {
                ConnectionStream imageConnectionStream2 = new ConnectionStream(null, cacheHelper.get(key));
                byte[] imageBytes = InputStreamUtils.getAllBytes(imageConnectionStream2.getInputStream());
                codec = ImageUtils.getImageCodec(imageBytes);
                resp.setContentType(ImageUtils.getContentTypeString(codec));
                resp.setContentLength(imageBytes.length);
                resp.getOutputStream().write(imageBytes);
                resp.flushBuffer();
                return;
            }
            imageConnectionStream = imageReader.getStream(path);
            outStream = new ByteArrayOutputStream(4096);
        } else {
            imageConnectionStream = imageReader.getStream(path);
            outStream = new MobyletServletOutputStream((OutputStream)resp.getOutputStream());
        }
        if (imageConnectionStream == null) {
            return;
        }
        if (codec == null && (codec = ImageUtils.getImageCodec(imageConnectionStream)) == null) {
            codec = ImageCodec.JPG;
        }
        resp.setContentType(ImageUtils.getContentTypeString(codec));
        imageScaler.scale(imageConnectionStream.getInputStream(), (OutputStream)outStream, codec, ImageUtils.getScaledWidth(), ImageUtils.getScaleType());
        if (imageConnectionStream.getConnection() != null) {
            imageConnectionStream.getConnection().disconnect();
        }
        byte[] imageBytes = null;
        if (outStream instanceof ByteArrayOutputStream) {
            imageBytes = ((ByteArrayOutputStream)ByteArrayOutputStream.class.cast(outStream)).toByteArray();
            if (imageBytes != null) {
                resp.setContentLength(imageBytes.length);
                resp.getOutputStream().write(imageBytes);
            }
            resp.flushBuffer();
            if (enableCache && imageBytes != null && StringUtils.isNotEmpty(key)) {
                cacheHelper.put(key, new ByteArrayInputStream(imageBytes));
            }
        } else if (outStream instanceof MobyletServletOutputStream) {
            MobyletServletOutputStream msos = (MobyletServletOutputStream)((Object)MobyletServletOutputStream.class.cast(outStream));
            resp.setContentLength(msos.getLength());
            resp.flushBuffer();
        }
    }
}

