/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.mobylet.core.Carrier;
import org.mobylet.core.Mobylet;
import org.mobylet.core.MobyletFactory;
import org.mobylet.core.config.MobyletConfig;
import org.mobylet.core.dialect.MobyletDialect;
import org.mobylet.core.http.CSSExpandPrintWriter;
import org.mobylet.core.http.MobyletBufferedServletOutputStream;
import org.mobylet.core.http.MobyletPrintWriter;
import org.mobylet.core.http.MobyletServletOutputStream;
import org.mobylet.core.http.ProxyImageOutputStream;
import org.mobylet.core.image.ImageScaler;
import org.mobylet.core.type.ContentType;
import org.mobylet.core.util.ImageUtils;
import org.mobylet.core.util.RequestUtils;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;

public class MobyletResponse
extends HttpServletResponseWrapper {
    public static final Pattern REG_JSESSIONID = Pattern.compile(";jsessionid=[^?]+");
    protected HttpServletResponse response;
    protected MobyletDialect dialect;
    protected PrintWriter printWriter;
    protected ServletOutputStream outputStream;
    protected String contentType;
    protected boolean hasContentType = false;

    public MobyletResponse(HttpServletResponse response, MobyletDialect dialect) {
        super(response);
        this.dialect = dialect;
        this.response = response;
    }

    public void setContentType(String type) {
        if (!this.hasContentType) {
            String string = this.contentType = type == null ? this.contentType : type;
            if (StringUtils.isNotEmpty(this.contentType) && RequestUtils.getMobyletContext().get(Ready.class) != null) {
                super.setContentType(this.contentType);
                this.hasContentType = true;
            } else {
                Mobylet m = MobyletFactory.getInstance();
                this.contentType = m != null && m.getContentType() == ContentType.XHTML ? this.dialect.getXContentTypeString() : this.dialect.getContentTypeString();
                super.setContentType(this.contentType);
            }
        } else {
            super.setContentType(type);
        }
    }

    public PrintWriter getWriter() throws IOException {
        if (this.printWriter == null) {
            if (RequestUtils.isIncludeScope() && !this.isRootResponse()) {
                Mobylet m = MobyletFactory.getInstance();
                RequestUtils.getMobyletContext().set(new Ready());
                if (m != null && m.getContentType() == ContentType.XHTML) {
                    this.setContentType(this.dialect.getXContentTypeString());
                } else {
                    this.setContentType(this.dialect.getContentTypeString());
                }
                this.printWriter = super.getWriter();
            } else {
                this.printWriter = new MobyletPrintWriter((Writer)new OutputStreamWriter((OutputStream)this.getMobyletOutputStream(), this.dialect.getCharset()), this.dialect.getCarrier());
                Mobylet m = MobyletFactory.getInstance();
                RequestUtils.getMobyletContext().set(new Ready());
                if (m != null && m.getContentType() == ContentType.XHTML) {
                    MobyletConfig config = SingletonUtils.get(MobyletConfig.class);
                    if (m.getCarrier() == Carrier.DOCOMO && config.useCSSExpand()) {
                        this.printWriter = new CSSExpandPrintWriter(this.printWriter);
                    }
                    this.setContentType(this.dialect.getXContentTypeString());
                } else {
                    this.setContentType(this.dialect.getContentTypeString());
                }
            }
        }
        return this.printWriter;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            String imgContentType = null;
            if (this.dialect.getCarrier() != Carrier.OTHER && (imgContentType = ImageUtils.getContentTypeStringByRequestURI()) != null) {
                RequestUtils.getMobyletContext().set(new Ready());
                this.setContentType(imgContentType);
                this.outputStream = ImageUtils.isAutoScale() ? new ProxyImageOutputStream() : super.getOutputStream();
            } else {
                RequestUtils.getMobyletContext().set(new Ready());
                this.setContentType(this.contentType);
                this.outputStream = new MobyletBufferedServletOutputStream(this, (OutputStream)super.getOutputStream());
            }
        }
        return this.outputStream;
    }

    public String encodeURL(String url) {
        MobyletConfig config = SingletonUtils.get(MobyletConfig.class);
        switch (config.getJSession()) {
            case DEFAULT: 
            case USE_QUERY: {
                return super.encodeURL(url);
            }
        }
        String encodeURL = super.encodeURL(url);
        if (encodeURL.indexOf(59) >= 0) {
            return REG_JSESSIONID.matcher(encodeURL).replaceFirst("");
        }
        return encodeURL;
    }

    public String encodeRedirectURL(String url) {
        MobyletConfig config = SingletonUtils.get(MobyletConfig.class);
        switch (config.getJSession()) {
            case DEFAULT: 
            case USE_QUERY: {
                return super.encodeRedirectURL(url);
            }
        }
        String encodeURL = super.encodeRedirectURL(url);
        if (encodeURL.indexOf(59) >= 0) {
            return REG_JSESSIONID.matcher(encodeURL).replaceFirst("");
        }
        return encodeURL;
    }

    public void addHeader(String name, String value) {
        MobyletConfig config = SingletonUtils.get(MobyletConfig.class);
        switch (config.getJSession()) {
            case DEFAULT: 
            case USE_COOKIE: {
                super.addHeader(name, value);
                return;
            }
        }
        if (!StringUtils.isNotEmpty(name) || !name.equalsIgnoreCase("Set-Cookie")) {
            super.addHeader(name, value);
        }
    }

    public void flushByMobylet() throws IOException {
        if (this.printWriter != null) {
            if (this.printWriter instanceof CSSExpandPrintWriter) {
                ((CSSExpandPrintWriter)CSSExpandPrintWriter.class.cast(this.printWriter)).flushByMobylet();
            }
            this.printWriter.flush();
        } else if (this.outputStream != null) {
            if (this.outputStream instanceof ProxyImageOutputStream) {
                MobyletServletOutputStream outStream = new MobyletServletOutputStream((OutputStream)super.getOutputStream());
                SingletonUtils.get(ImageScaler.class).scale(((ProxyImageOutputStream)((Object)ProxyImageOutputStream.class.cast(this.outputStream))).getWrittenBytesInputStream(), (OutputStream)((Object)outStream), ImageUtils.getImageCodec(), ImageUtils.getScaledWidth(), ImageUtils.getScaleType());
                this.setContentLength(outStream.getLength());
            }
            this.outputStream.flush();
        }
    }

    public void sendRedirect(String location) throws IOException {
        RequestUtils.getMobyletContext().set(new Ready());
        Mobylet m = SingletonUtils.get(Mobylet.class);
        if (m != null && m.getContentType() == ContentType.XHTML) {
            this.setContentType(this.dialect.getXContentTypeString());
        } else {
            this.setContentType(this.dialect.getContentTypeString());
        }
        super.sendRedirect(location);
    }

    public void sendError(int sc, String msg) throws IOException {
        RequestUtils.getMobyletContext().set(new Ready());
        Mobylet m = SingletonUtils.get(Mobylet.class);
        if (m != null && m.getContentType() == ContentType.XHTML) {
            this.setContentType(this.dialect.getXContentTypeString());
        } else {
            this.setContentType(this.dialect.getContentTypeString());
        }
        super.sendError(sc, msg);
    }

    protected boolean isRootResponse() {
        return ((Object)((Object)this)).equals((Object)RequestUtils.getMobyletContext().get(MobyletResponse.class));
    }

    protected ServletOutputStream getMobyletOutputStream() throws IOException {
        return this.getOutputStream();
    }

    public static class Ready {
    }
}

