/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.http;

import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.mobylet.core.dialect.MobyletDialect;
import org.mobylet.core.http.ForceWrapMobyletResponse;
import org.mobylet.core.http.MobyletFilter;
import org.mobylet.core.http.MobyletResponse;
import org.mobylet.core.http.util.ForceWrapUtils;
import org.mobylet.core.util.RequestUtils;
import org.mobylet.core.util.StringUtils;

public class ForceWrapMobyletFilter
extends MobyletFilter {
    protected boolean isAllForceWrap = false;
    protected String proxyCharset = "UTF-8";

    @Override
    protected MobyletResponse wrapResponse(HttpServletResponse response, MobyletDialect dialect) {
        if (this.isAllForceWrap) {
            ForceWrapUtils.setForceWrapRequest();
        }
        RequestUtils.get().setAttribute("X_MOBYLET_PROXY_CHARSET", (Object)this.proxyCharset);
        return new ForceWrapMobyletResponse(response, dialect);
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        if (filterConfig != null) {
            this.isAllForceWrap = "true".equalsIgnoreCase(filterConfig.getInitParameter("isAllForceWrap"));
            if (StringUtils.isNotEmpty(filterConfig.getInitParameter("proxyCharset"))) {
                this.proxyCharset = filterConfig.getInitParameter("proxyCharset");
            }
        }
    }
}

