/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.mobylet.core.config.MobyletConfig;
import org.mobylet.core.config.enums.SessionKey;
import org.mobylet.core.config.xml.MobyletSessionConfigXml;
import org.mobylet.core.ip.IpAddress;
import org.mobylet.core.ip.IpAddressList;
import org.mobylet.core.log.MobyletLogger;
import org.mobylet.core.session.MobyletSessionAdapter;
import org.mobylet.core.util.ConfigUtils;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.XmlUtils;
import org.mobylet.core.xml.Xml;
import org.mobylet.core.xml.XmlNode;

public class MobyletSessionConfig
implements MobyletSessionConfigXml {
    protected SessionKey key;
    protected int timeout;
    protected MobyletSessionAdapter adapter;
    protected Distribution distribution;
    protected boolean isFailed = false;

    public MobyletSessionConfig() {
        this.initialize();
    }

    protected void initialize() {
        String path;
        MobyletConfig config = SingletonUtils.get(MobyletConfig.class);
        MobyletLogger logger = SingletonUtils.get(MobyletLogger.class);
        String string = path = config.getConfigDir().equals("." + File.separator) ? "mobyletSession.xml" : config.getConfigDir() + "mobyletSession.xml";
        if (this.isFailed) {
            path = "mobyletSession.xml";
        }
        if (logger != null && logger.isLoggable()) {
            logger.log("[mobylet] " + path + " \u306e\u8aad\u307f\u8fbc\u307f\u51e6\u7406\u958b\u59cb");
        }
        try {
            Xml mobyletSessionXml = new Xml(path);
            XmlNode root = mobyletSessionXml.getRootNode();
            this.key = SessionKey.valueOf(XmlUtils.getValue(root, "key"));
            this.timeout = Integer.parseInt(XmlUtils.getValue(root, "timeout"));
            try {
                this.adapter = (MobyletSessionAdapter)MobyletSessionAdapter.class.cast(Class.forName(XmlUtils.getValue(root, "adapter")).newInstance());
                SingletonUtils.put(this.adapter);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            if (root.getNodeListByXPath("distribution").size() == 1) {
                List<XmlNode> ips;
                List<XmlNode> hosts;
                this.distribution = new Distribution();
                this.distribution.setProtocol(XmlUtils.getValue(root, "distribution/protocol"));
                this.distribution.setPath(ConfigUtils.parseValue(XmlUtils.getValue(root, "distribution/path")));
                if (root.getNodeListByXPath("distribution/parameters").size() == 1) {
                    Parameters parameters = new Parameters(XmlUtils.getValue(root, "distribution/parameters/sessionKey"), XmlUtils.getValue(root, "distribution/parameters/objectData"), XmlUtils.getValue(root, "distribution/parameters/invokeType"));
                    this.distribution.setParameters(parameters);
                }
                if (root.getNodeListByXPath("distribution/receiveHosts").size() == 1 && (hosts = root.getNodeListByXPath("distribution/receiveHosts/host")) != null) {
                    for (XmlNode node : hosts) {
                        this.distribution.addReceiveHost(node.getAttributes().get("name"), node.getValue());
                    }
                }
                if (root.getNodeListByXPath("distribution/allowIps").size() == 1 && (ips = root.getNodeListByXPath("distribution/allowIps/ip")) != null) {
                    for (XmlNode node : ips) {
                        this.distribution.addAllowIp(node.getValue());
                    }
                }
            }
        }
        catch (RuntimeException e) {
            logger.log("[mobylet] " + path + " \u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557");
            if (!this.isFailed) {
                logger.log("[mobylet] mobyletSession.xml\u306e\u30c7\u30d5\u30a9\u30eb\u30c8\u8a2d\u5b9a\u3092\u6709\u52b9\u5316\u3057\u307e\u3059");
                this.isFailed = true;
                this.initialize();
            }
            throw e;
        }
        if (logger != null && logger.isLoggable()) {
            logger.log("[mobylet] " + path + " \u304c\u8aad\u307f\u8fbc\u307e\u308c\u307e\u3057\u305f");
        }
    }

    public SessionKey getKey() {
        return this.key;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public MobyletSessionAdapter getAdapter() {
        return this.adapter;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public static class Host {
        protected String name;
        protected String host;

        public Host(String name, String host) {
            this.name = name;
            this.host = host;
        }

        public String getName() {
            return this.name;
        }

        public String getHost() {
            return this.host;
        }
    }

    public static class Parameters {
        protected String sessionKey;
        protected String objectDataKey;
        protected String invokeTypeKey;

        public Parameters(String sessionKey, String objectDataKey, String invokeTypeKey) {
            this.sessionKey = sessionKey;
            this.objectDataKey = objectDataKey;
            this.invokeTypeKey = invokeTypeKey;
        }

        public String getSessionKey() {
            return this.sessionKey;
        }

        public String getObjectDataKey() {
            return this.objectDataKey;
        }

        public String getInvokeTypeKey() {
            return this.invokeTypeKey;
        }
    }

    public static class Distribution {
        protected String protocol;
        protected String path;
        protected Parameters parameters;
        protected List<Host> receiveHosts = new ArrayList<Host>();
        protected IpAddressList allowIps = new IpAddressList();

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setParameters(Parameters parameters) {
            this.parameters = parameters;
        }

        public Parameters getParameters() {
            return this.parameters;
        }

        public List<Host> getReceiveHosts() {
            return this.receiveHosts;
        }

        public void addReceiveHost(String name, String host) {
            this.receiveHosts.add(new Host(name, host));
        }

        public IpAddressList getAllowIps() {
            return this.allowIps;
        }

        public void addAllowIp(String ip) {
            this.allowIps.add(new IpAddress(ip));
        }

        public boolean isAllowIp(String ip) {
            int ipInteger = IpAddress.getIntegerIp(ip);
            for (IpAddress allowIp : this.allowIps) {
                if (!allowIp.containsIp(ipInteger)) continue;
                return true;
            }
            return false;
        }
    }
}

