/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.solr.request.NumberedTermEnum;

class TermIndex {
    static final int intervalBits = 7;
    static final int intervalMask = 127;
    static final int interval = 128;
    final Term fterm;
    final String prefix;
    String[] index;
    int nTerms;
    long sizeOfStrings;

    TermIndex(String field) {
        this(field, null);
    }

    TermIndex(String field, String prefix) {
        this.fterm = new Term(field, "");
        this.prefix = prefix;
    }

    Term createTerm(String termVal) {
        return this.fterm.createTerm(termVal);
    }

    NumberedTermEnum getEnumerator(IndexReader reader, int termNumber) throws IOException {
        NumberedTermEnum te = new NumberedTermEnum(reader, this);
        te.skipTo(termNumber);
        return te;
    }

    NumberedTermEnum getEnumerator(IndexReader reader) throws IOException {
        if (this.index == null) {
            return new NumberedTermEnum(reader, this, this.prefix == null ? "" : this.prefix, 0){
                ArrayList<String> lst;

                protected boolean setTerm() {
                    boolean b = super.setTerm();
                    if (b && (this.pos & 0x7F) == 0) {
                        String text = this.term().text();
                        TermIndex.this.sizeOfStrings += (long)(text.length() << 1);
                        if (this.lst == null) {
                            this.lst = new ArrayList();
                        }
                        this.lst.add(text);
                    }
                    return b;
                }

                public boolean skipTo(Term target) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public boolean skipTo(int termNumber) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public void close() throws IOException {
                    TermIndex.this.nTerms = this.pos;
                    super.close();
                    TermIndex.this.index = this.lst != null ? this.lst.toArray(new String[this.lst.size()]) : new String[]{};
                }
            };
        }
        return new NumberedTermEnum(reader, this, "", 0);
    }

    public long memSize() {
        return (long)(32 + (this.index.length << 3)) + this.sizeOfStrings;
    }
}

