/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.highlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.highlight.SolrFormatter;
import org.apache.solr.highlight.SolrFragmenter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.DocList;
import org.apache.solr.util.SolrPluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SolrHighlighter {
    public static Logger log = LoggerFactory.getLogger(SolrHighlighter.class);
    protected final Map<String, SolrFormatter> formatters = Collections.synchronizedMap(new HashMap());
    protected final Map<String, SolrFragmenter> fragmenters = Collections.synchronizedMap(new HashMap());

    @Deprecated
    public abstract void initalize(SolrConfig var1);

    public boolean isHighlightingEnabled(SolrParams params) {
        return params.getBool("hl", false);
    }

    public String[] getHighlightFields(Query query, SolrQueryRequest request, String[] defaultFields) {
        String[] fields = request.getParams().getParams("hl.fl");
        if (this.emptyArray(fields)) {
            if (this.emptyArray(defaultFields)) {
                String[] stringArray;
                String defaultSearchField = request.getSchema().getDefaultSearchFieldName();
                if (null == defaultSearchField) {
                    stringArray = new String[]{};
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = defaultSearchField;
                }
                fields = stringArray;
            } else {
                fields = defaultFields;
            }
        } else if (fields.length == 1) {
            if (fields[0].contains("*")) {
                String fieldRegex = fields[0].replaceAll("\\*", ".*");
                Collection<String> storedHighlightFieldNames = request.getSearcher().getStoredHighlightFieldNames();
                ArrayList<String> storedFieldsToHighlight = new ArrayList<String>();
                for (String storedFieldName : storedHighlightFieldNames) {
                    if (!storedFieldName.matches(fieldRegex)) continue;
                    storedFieldsToHighlight.add(storedFieldName);
                }
                fields = storedFieldsToHighlight.toArray(new String[0]);
            } else {
                fields = SolrPluginUtils.split(fields[0]);
            }
        }
        return fields;
    }

    protected boolean emptyArray(String[] arr) {
        return arr == null || arr.length == 0 || arr[0] == null || arr[0].trim().length() == 0;
    }

    public abstract NamedList<Object> doHighlighting(DocList var1, Query var2, SolrQueryRequest var3, String[] var4) throws IOException;
}

