/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.hotdeploy;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.framework.container.hotdeploy.HotdeployBehavior;
import org.seasar.framework.container.hotdeploy.HotdeployHttpServletRequest;
import org.seasar.framework.container.hotdeploy.HotdeployHttpSession;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;
import org.seasar.framework.container.impl.S2ContainerBehavior;

public class HotdeployFilter
implements Filter {
    private static final String MODE = "mode";
    private static final String AUTO = "auto";
    private static final String MANUAL = "manual";
    private static final String PATH = "/hotdeploy";
    private static final String KEY = HotdeployFilter.class.getName();
    private boolean autoMode = true;

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (HotdeployUtil.isHotdeploy()) {
            this.doHotdeployFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
            return;
        }
        chain.doFilter(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHotdeployFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String path = request.getPathInfo();
        if (PATH.equals(path)) {
            this.changeMode(request, response);
            return;
        }
        if (request.getAttribute(KEY) != null) {
            ClassLoader cl = (ClassLoader)request.getAttribute(KEY);
            Thread.currentThread().setContextClassLoader(cl);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        HotdeployBehavior ondemand = (HotdeployBehavior)S2ContainerBehavior.getProvider();
        Class clazz = HotdeployFilter.class;
        synchronized (clazz) {
            ondemand.start();
            HotdeployHttpServletRequest hotdeployRequest = new HotdeployHttpServletRequest(request);
            try {
                request.setAttribute(KEY, (Object)Thread.currentThread().getContextClassLoader());
                chain.doFilter((ServletRequest)hotdeployRequest, (ServletResponse)response);
            }
            finally {
                HotdeployHttpSession session = (HotdeployHttpSession)hotdeployRequest.getSession(false);
                if (session != null) {
                    session.flush();
                }
                request.removeAttribute(KEY);
                ondemand.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeMode(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Class clazz = HotdeployFilter.class;
        synchronized (clazz) {
            HotdeployBehavior ondemand = (HotdeployBehavior)S2ContainerBehavior.getProvider();
            response.setContentType("text/html");
            PrintWriter writer = response.getWriter();
            String mode = request.getParameter(MODE);
            if (AUTO.equals(mode) || MANUAL.equals(mode)) {
                this.autoMode = AUTO.equals(mode);
                ondemand.setKeep(!this.autoMode);
                writer.println("<html><body>HOT deploy mode : " + mode + "</body></html>");
            } else {
                writer.println("<html><body>ERROR! Invalid HOT deploy mode : " + mode + "<br>Valid values : 'auto' or 'manual'</body></html>");
            }
        }
    }
}

