/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.fontbox.afm.AFMParser;
import org.apache.fontbox.afm.FontMetric;
import org.apache.fontbox.cmap.CMap;
import org.apache.fontbox.cmap.CMapParser;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.encoding.AFMEncoding;
import org.apache.pdfbox.encoding.DictionaryEncoding;
import org.apache.pdfbox.encoding.Encoding;
import org.apache.pdfbox.encoding.EncodingManager;
import org.apache.pdfbox.encoding.conversion.CMapSubstitution;
import org.apache.pdfbox.encoding.conversion.EncodingConversionManager;
import org.apache.pdfbox.encoding.conversion.EncodingConverter;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDMatrix;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFontFactory;
import org.apache.pdfbox.util.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PDFont
implements COSObjectable {
    protected COSDictionary font;
    private Encoding fontEncoding = null;
    private CMap cmap = null;
    private static Map<COSName, CMap> cmapObjects = Collections.synchronizedMap(new HashMap());
    private static final Map<String, FontMetric> afmObjects = Collections.unmodifiableMap(PDFont.getAdobeFontMetrics());
    private boolean hasToUnicode = false;
    private FontMetric afm = null;
    private COSBase encodingObject = null;
    private static final String[] SINGLE_CHAR_STRING = new String[256];
    private static final String[][] DOUBLE_CHAR_STRING = new String[256][256];
    private String subtype = null;
    private boolean type0Font;
    private boolean trueTypeFont;
    private boolean typeFont;
    private static EncodingManager encodingManager;

    private static Map<String, FontMetric> getAdobeFontMetrics() {
        HashMap<String, FontMetric> metrics = new HashMap<String, FontMetric>();
        PDFont.addAdobeFontMetric(metrics, "Courier-Bold");
        PDFont.addAdobeFontMetric(metrics, "Courier-BoldOblique");
        PDFont.addAdobeFontMetric(metrics, "Courier");
        PDFont.addAdobeFontMetric(metrics, "Courier-Oblique");
        PDFont.addAdobeFontMetric(metrics, "Helvetica");
        PDFont.addAdobeFontMetric(metrics, "Helvetica-Bold");
        PDFont.addAdobeFontMetric(metrics, "Helvetica-BoldOblique");
        PDFont.addAdobeFontMetric(metrics, "Helvetica-Oblique");
        PDFont.addAdobeFontMetric(metrics, "Symbol");
        PDFont.addAdobeFontMetric(metrics, "Times-Bold");
        PDFont.addAdobeFontMetric(metrics, "Times-BoldItalic");
        PDFont.addAdobeFontMetric(metrics, "Times-Italic");
        PDFont.addAdobeFontMetric(metrics, "Times-Roman");
        PDFont.addAdobeFontMetric(metrics, "ZapfDingbats");
        return metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addAdobeFontMetric(Map<String, FontMetric> metrics, String name) {
        block5: {
            try {
                String resource = "org/apache/pdfbox/resources/afm/" + name + ".afm";
                InputStream afmStream = ResourceLoader.loadResource(resource);
                if (afmStream == null) break block5;
                try {
                    AFMParser parser = new AFMParser(afmStream);
                    parser.parse();
                    metrics.put(name, parser.getResult());
                }
                finally {
                    afmStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void clearResources() {
        cmapObjects.clear();
    }

    public PDFont() {
        this.font = new COSDictionary();
        this.font.setItem(COSName.TYPE, (COSBase)COSName.FONT);
    }

    public PDFont(COSDictionary fontDictionary) {
        this.font = fontDictionary;
    }

    @Override
    public COSBase getCOSObject() {
        return this.font;
    }

    public abstract float getFontWidth(byte[] var1, int var2, int var3) throws IOException;

    public abstract float getFontHeight(byte[] var1, int var2, int var3) throws IOException;

    public float getStringWidth(String string) throws IOException {
        byte[] data = string.getBytes();
        float totalWidth = 0.0f;
        for (int i = 0; i < data.length; ++i) {
            totalWidth += this.getFontWidth(data, i, 1);
        }
        return totalWidth;
    }

    public abstract float getAverageFontWidth() throws IOException;

    public abstract void drawString(String var1, Graphics var2, float var3, AffineTransform var4, float var5, float var6) throws IOException;

    protected int getCodeFromArray(byte[] data, int offset, int length) {
        int code = 0;
        for (int i = 0; i < length; ++i) {
            code <<= 8;
            code |= (data[offset + i] + 256) % 256;
        }
        return code;
    }

    protected float getFontWidthFromAFMFile(int code) throws IOException {
        float retval = 0.0f;
        FontMetric metric = this.getAFM();
        if (metric != null) {
            Encoding encoding = this.getEncoding();
            String characterName = encoding.getName(code);
            retval = metric.getCharacterWidth(characterName);
        }
        return retval;
    }

    protected float getAverageFontWidthFromAFMFile() throws IOException {
        float retval = 0.0f;
        FontMetric metric = this.getAFM();
        if (metric != null) {
            retval = metric.getAverageCharacterWidth();
        }
        return retval;
    }

    protected FontMetric getAFM() throws IOException {
        if (this.afm == null) {
            COSBase baseFont = this.font.getDictionaryObject(COSName.BASE_FONT);
            String name = null;
            if (baseFont instanceof COSName) {
                name = ((COSName)baseFont).getName();
                if (name.indexOf("+") > -1) {
                    name = name.substring(name.indexOf("+") + 1);
                }
            } else if (baseFont instanceof COSString) {
                COSString string = (COSString)baseFont;
                name = string.getString();
            }
            if (name != null) {
                this.afm = afmObjects.get(name);
            }
        }
        return this.afm;
    }

    private COSBase getEncodingObject() {
        if (this.encodingObject == null) {
            this.encodingObject = this.font.getDictionaryObject(COSName.ENCODING);
        }
        return this.encodingObject;
    }

    public String encode(byte[] c, int offset, int length) throws IOException {
        EncodingConverter converter;
        COSObjectable encoding;
        String retval = null;
        if (this.isTypeFont() && this.cmap == null) {
            COSBase toUnicode = this.font.getDictionaryObject(COSName.TO_UNICODE);
            if (toUnicode instanceof COSStream) {
                this.hasToUnicode = true;
                this.parseCmap(null, ((COSStream)toUnicode).getUnfilteredStream(), null);
            } else {
                encoding = this.getEncodingObject();
                if (encoding instanceof COSStream) {
                    COSStream encodingStream = (COSStream)encoding;
                    this.parseCmap(null, encodingStream.getUnfilteredStream(), null);
                } else if (this.isType0Font() && encoding instanceof COSName) {
                    COSName encodingName = (COSName)encoding;
                    this.cmap = cmapObjects.get(encodingName);
                    if (this.cmap == null) {
                        String cmapName = encodingName.getName();
                        if (encodingName.getName().equals(COSName.IDENTITY_H.getName())) {
                            COSArray descendantFontArray = (COSArray)this.font.getDictionaryObject(COSName.DESCENDANT_FONTS);
                            if (descendantFontArray != null) {
                                COSDictionary descendantFontDictionary = (COSDictionary)descendantFontArray.getObject(0);
                                PDFont descendentFont = PDFontFactory.createFont(descendantFontDictionary);
                                COSDictionary cidsysteminfo = (COSDictionary)descendentFont.font.getDictionaryObject(COSName.CIDSYSTEMINFO);
                                if (cidsysteminfo != null) {
                                    String ordering = cidsysteminfo.getString(COSName.ORDERING);
                                    String registry = cidsysteminfo.getString(COSName.REGISTRY);
                                    cmapName = registry + "-" + ordering + "-UCS2";
                                }
                            }
                        } else {
                            cmapName = CMapSubstitution.substituteCMap(cmapName);
                        }
                        String resourceRoot = "org/apache/pdfbox/resources/cmap/";
                        String resourceName = resourceRoot + cmapName;
                        this.parseCmap(resourceRoot, ResourceLoader.loadResource(resourceName), encodingName);
                        if (this.cmap == null && !encodingName.getName().equals(COSName.IDENTITY_H.getName())) {
                            throw new IOException("Error: Could not find predefined CMAP file for '" + encodingName.getName() + "'");
                        }
                    }
                } else if (encoding instanceof COSName || encoding instanceof COSDictionary) {
                    Encoding currentFontEncoding = this.getEncoding();
                    if (currentFontEncoding != null) {
                        retval = currentFontEncoding.getCharacter(this.getCodeFromArray(c, offset, length));
                    }
                } else {
                    COSDictionary fontDescriptor = (COSDictionary)this.font.getDictionaryObject(COSName.FONT_DESC);
                    if (this.isTrueTypeFont() && fontDescriptor != null && (fontDescriptor.getDictionaryObject(COSName.FONT_FILE) != null || fontDescriptor.getDictionaryObject(COSName.FONT_FILE2) != null || fontDescriptor.getDictionaryObject(COSName.FONT_FILE3) != null)) {
                        retval = PDFont.getStringFromArray(c, offset, length);
                    }
                }
            }
        }
        if (retval == null && this.cmap != null) {
            retval = this.cmap.lookup(c, offset, length);
        }
        COSBase encodingCOS = this.getEncodingObject();
        if (!this.hasToUnicode && encodingCOS instanceof COSName && (converter = EncodingConversionManager.getConverter(((COSName)encodingCOS).getName())) != null) {
            retval = retval != null ? converter.convertString(retval) : converter.convertBytes(c, offset, length, this.cmap);
            return retval;
        }
        if (!(retval != null || length != 1 || this.cmap != null && this.cmap.hasTwoByteMappings())) {
            encoding = this.getEncoding();
            if (encoding != null) {
                retval = ((Encoding)encoding).getCharacter(this.getCodeFromArray(c, offset, length));
            }
            if (retval == null) {
                retval = PDFont.getStringFromArray(c, offset, length);
            }
        }
        return retval;
    }

    private static String getStringFromArray(byte[] c, int offset, int length) throws IOException {
        String retval = null;
        if (length == 1) {
            retval = SINGLE_CHAR_STRING[(c[offset] + 256) % 256];
        } else if (length == 2) {
            retval = DOUBLE_CHAR_STRING[(c[offset] + 256) % 256][(c[offset + 1] + 256) % 256];
        } else {
            throw new IOException("Error:Unknown character length:" + length);
        }
        return retval;
    }

    private void parseCmap(String cmapRoot, InputStream cmapStream, COSName encodingName) throws IOException {
        if (cmapStream != null) {
            CMapParser parser = new CMapParser();
            this.cmap = parser.parse(cmapRoot, cmapStream);
            if (encodingName != null) {
                cmapObjects.put(encodingName, this.cmap);
            }
        }
    }

    public void setEncoding(Encoding enc) {
        this.font.setItem(COSName.ENCODING, (COSObjectable)enc);
        this.fontEncoding = enc;
    }

    public Encoding getEncoding() throws IOException {
        if (this.fontEncoding == null) {
            EncodingManager manager = PDFont.getEncodingManager();
            COSBase encoding = this.getEncodingObject();
            if (encoding == null) {
                FontMetric metric = this.getAFM();
                if (metric != null) {
                    this.fontEncoding = new AFMEncoding(metric);
                }
                if (this.fontEncoding == null) {
                    this.fontEncoding = manager.getStandardEncoding();
                }
            } else if (encoding instanceof COSDictionary) {
                COSDictionary encodingDic = (COSDictionary)encoding;
                COSName baseEncodingName = (COSName)encodingDic.getDictionaryObject(COSName.BASE_ENCODING);
                if (baseEncodingName == null) {
                    COSName fontEncodingFromFile = this.getEncodingFromFont();
                    encodingDic.setItem(COSName.BASE_ENCODING, (COSBase)fontEncodingFromFile);
                }
                this.fontEncoding = new DictionaryEncoding(encodingDic);
            } else if (encoding instanceof COSName) {
                if (!encoding.equals(COSName.IDENTITY_H)) {
                    this.fontEncoding = manager.getEncoding((COSName)encoding);
                }
            } else {
                throw new IOException("Unexpected encoding type:" + encoding.getClass().getName());
            }
        }
        return this.fontEncoding;
    }

    public String getType() {
        return this.font.getNameAsString(COSName.TYPE);
    }

    public String getSubType() {
        if (this.subtype == null) {
            this.subtype = this.font.getNameAsString(COSName.SUBTYPE);
            this.type0Font = "Type0".equals(this.subtype);
            this.trueTypeFont = "TrueType".equals(this.subtype);
            this.typeFont = this.type0Font || "Type1".equals(this.subtype) || this.trueTypeFont;
        }
        return this.subtype;
    }

    private boolean isType0Font() {
        this.getSubType();
        return this.type0Font;
    }

    private boolean isTrueTypeFont() {
        this.getSubType();
        return this.trueTypeFont;
    }

    private boolean isTypeFont() {
        this.getSubType();
        return this.typeFont;
    }

    public String getBaseFont() {
        return this.font.getNameAsString(COSName.BASE_FONT);
    }

    public void setBaseFont(String baseFont) {
        this.font.setName(COSName.BASE_FONT, baseFont);
    }

    public int getFirstChar() {
        return this.font.getInt(COSName.FIRST_CHAR, -1);
    }

    public void setFirstChar(int firstChar) {
        this.font.setInt(COSName.FIRST_CHAR, firstChar);
    }

    public int getLastChar() {
        return this.font.getInt(COSName.LAST_CHAR, -1);
    }

    public void setLastChar(int lastChar) {
        this.font.setInt(COSName.LAST_CHAR, lastChar);
    }

    public List getWidths() {
        COSArray array = (COSArray)this.font.getDictionaryObject(COSName.WIDTHS);
        return COSArrayList.convertFloatCOSArrayToList(array);
    }

    public void setWidths(List widths) {
        this.font.setItem(COSName.WIDTHS, (COSBase)COSArrayList.converterToCOSArray(widths));
    }

    public PDMatrix getFontMatrix() {
        PDMatrix matrix = null;
        COSArray array = (COSArray)this.font.getDictionaryObject(COSName.FONT_MATRIX);
        if (array == null) {
            array = new COSArray();
            array.add(new COSFloat(0.001f));
            array.add(COSInteger.ZERO);
            array.add(COSInteger.ZERO);
            array.add(new COSFloat(0.001f));
            array.add(COSInteger.ZERO);
            array.add(COSInteger.ZERO);
        }
        matrix = new PDMatrix(array);
        return matrix;
    }

    private COSName getEncodingFromFont() throws IOException {
        COSStream fontFile;
        COSName retvalue = null;
        COSDictionary fontDescriptor = (COSDictionary)this.font.getDictionaryObject(COSName.FONT_DESC);
        if (fontDescriptor != null && (fontFile = (COSStream)fontDescriptor.getDictionaryObject(COSName.FONT_FILE)) != null) {
            BufferedReader in = new BufferedReader(new InputStreamReader(fontFile.getUnfilteredStream()));
            StringTokenizer st = null;
            boolean found = false;
            String line = "";
            String key = null;
            for (int i = 0; null != (line = in.readLine()) && i < 40 && !line.equals("currentdict end") && !found; ++i) {
                st = new StringTokenizer(line);
                if (!st.hasMoreTokens() || !(key = st.nextToken()).equals("/Encoding") || !st.hasMoreTokens()) continue;
                COSName value = COSName.getPDFName(st.nextToken());
                found = true;
                if (!value.equals(COSName.MAC_ROMAN_ENCODING) && !value.equals(COSName.PDF_DOC_ENCODING) && !value.equals(COSName.STANDARD_ENCODING) && !value.equals(COSName.WIN_ANSI_ENCODING)) continue;
                retvalue = value;
            }
        }
        return retvalue;
    }

    public abstract PDRectangle getFontBoundingBox() throws IOException;

    public boolean equals(Object other) {
        return other instanceof PDFont && ((PDFont)other).getCOSObject() == this.getCOSObject();
    }

    public int hashCode() {
        return this.getCOSObject().hashCode();
    }

    protected static EncodingManager getEncodingManager() {
        if (encodingManager == null) {
            encodingManager = new EncodingManager();
        }
        return encodingManager;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            PDFont.SINGLE_CHAR_STRING[i] = new String(new byte[]{(byte)i});
            for (int j = 0; j < 256; ++j) {
                PDFont.DOUBLE_CHAR_STRING[i][j] = new String(new byte[]{(byte)i, (byte)j});
            }
        }
        encodingManager = null;
    }
}

