/*
 * $Id: InputControlView.java,v 1.1 2006/04/27 13:52:01 sugimotokenichi Exp $
 * Copyright (C) 2004-2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/04/27
 */
package feat2.testapp.form;

import feat2.CommandContext;
import feat2.View;
import feat2.config.ViewConfig;
import feat2.template.HTMLDocument;
import feat2.template.HTMLElement;
import feat2.template.NodeNotFoundException;
import feat2.template.form.Form;

public class InputControlView implements View {

    private String type;
    private String[] value;

    public HTMLDocument format(HTMLDocument template, ViewConfig cfg,
            CommandContext ctx) throws Exception {

        if ( type == null )
            type = "textfield";

        try {
            HTMLElement control = template.findElement(type);
            control.detach();
            HTMLElement container = template.findElement("control");
            container.clear();
            container.addChild(control);

            Form form = new Form(template.findElement("form1"));
            form.setValue("value", value);
            form.setValue("type", type);
        }
        catch (NodeNotFoundException ex) {
            ((HTMLElement)template.find("html/body")).addText("NodeNotFoundException");
        }

        return template;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setValue(String[] value) {
        this.value = value;
    }



}
