/*
 * $Id: HTMLCompositeNodeImpl.java,v 1.2 2006/04/21 15:04:21 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/10/29
 */
package feat2.template.impl;

import feat2.template.CompositeNode;
import feat2.template.HTMLElement;
import feat2.template.HTMLNode;
import feat2.template.HTMLText;
import feat2.template.NodeListIterator;
import feat2.template.NodeNotFoundException;
import feat2.template.NodeSelector;
import feat2.template.NodeTreeIterator;

/**
 * HTMLNode̎B
 * @author SUGIMOTO Ken-ichi
 */
abstract public class HTMLCompositeNodeImpl extends HTMLNodeImpl implements CompositeNode {

    //private static Log log = LogFactory.getLog(HTMLCompositeNodeImpl.class);

    public HTMLNodeImpl firstChild;

    public void setFirstChild(HTMLNode child) {
        this.firstChild = (HTMLNodeImpl)child;
    }

    /**
     * nodeƂȍ~̌Zm[hc[؂藣B
     * @param node null̂Ƃ͉Ȃ
     * @return 폜m[hBXg\͕ۂ邪em[hւ̎QƂ͂ȂȂĂ
     */
    protected HTMLNode detachAll(HTMLNode node) {
        if ( node == null )
            return null;

        // Õm[hƂ̎QƂ؂
        try {
            ((HTMLNodeImpl)node.getPrev()).setNext(null);
        }
        catch (NodeNotFoundException ex) {
        }

        // em[h̎QƂ؂
        try {
            HTMLNodeImpl parentNode = (HTMLNodeImpl)(node.getParent());
            if ( parentNode.getFirstChild() == node ) {
                parentNode.setFirstChild(null);
            }
        }
        catch (NodeNotFoundException ex1) {
        }

        // em[hւ̎QƂ؂
        TemplateUtil.setParentAll((HTMLNodeImpl)node, null, null);

        return node;
    }

    // HTMLNode̎ ------------------------------------------------------------

    public HTMLNode getFirstChild() throws NodeNotFoundException {
        if ( firstChild == null )
            throw new NodeNotFoundException();

        return firstChild;
    }

    // CompositeNode̎ -------------------------------------------------------

    public void addChild(HTMLNode node) {
        if ( node == null )
            return;

        HTMLNodeImpl child = (HTMLNodeImpl)node;

        // qm[hȂ΍ŏ̎qm[hƂĒǉ
        if ( firstChild == null ) {
            firstChild = child;
            child.setPrev(null);
        }
        // qm[hꍇ͖ɒǉ
        else {
            firstChild.getLast().insertAfter(child);
        }

        TemplateUtil.setParentAll(child, null, this);
    }

    public String getString() {
        StringBuffer buf = new StringBuffer();
        NodeListIterator it = new NodeListIterator(firstChild);
        HTMLText textNode;
        while( (textNode = NodeSelector.getText(it)) != null ) {
            buf.append(textNode.getText());
        }
        return buf.toString();
    }

    public void setText(String text) {
        clear();
        if ( text != null )
            addText(text);
    }

    public void addText(String text) {
        if ( text == null )
            return;

        HTMLText textNode = null;

        try {
            // ̃eLXgm[hɒǉ

            HTMLNode lastChild = getFirstChild().getLast();
            if ( lastChild instanceof HTMLTextImpl ) {
                ((HTMLTextImpl)lastChild).addText(text);
                return;
            }
        }
        catch (NodeNotFoundException ex) {
        }

        // eLXgm[hȂƂ͐V

        if ( textNode == null )
            textNode = new HTMLTextImpl();

        textNode.setText(text);
        addChild(textNode);

    }

    public void clear() {
        if ( firstChild == null )
            return;

        // em[hւ̎QƂ؂
        TemplateUtil.setParentAll((HTMLNodeImpl)firstChild, null, null);

        firstChild = null;
    }

    public HTMLText getText() throws NodeNotFoundException {
        HTMLText ret = NodeSelector.getText(new NodeListIterator(firstChild));
        if ( ret == null )
            throw new NodeNotFoundException();
        return ret;
    }

    public HTMLText getText(int n) throws NodeNotFoundException {
        HTMLText ret = NodeSelector.getText(new NodeListIterator(firstChild), n);
        if ( ret == null )
            throw new NodeNotFoundException();
        return ret;
    }

    public HTMLText getLastText() throws NodeNotFoundException {
        HTMLText ret = NodeSelector.getLastText(new NodeListIterator(firstChild));
        if ( ret == null )
            throw new NodeNotFoundException();
        return ret;
    }

    public HTMLElement getTag(String tagName) throws NodeNotFoundException {
        HTMLElement ret = NodeSelector.getTag(new NodeListIterator(firstChild), tagName);
        if ( ret == null )
            throw new NodeNotFoundException();
        return ret;
    }

    public HTMLElement getTag(String tagName, int n) throws NodeNotFoundException {
        HTMLElement ret = NodeSelector.getTag(new NodeListIterator(firstChild), tagName, n);
        if ( ret == null )
            throw new NodeNotFoundException();
        return ret;
    }

    public HTMLElement getLastTag(String tagName) throws NodeNotFoundException {
        HTMLElement ret = NodeSelector.getLastTag(new NodeListIterator(firstChild), tagName);
        if ( ret == null )
            throw new NodeNotFoundException();
        return ret;
    }

    public int count() {
        int count = 0;
        for(NodeTreeIterator it = new NodeTreeIterator(this); it.hasNext(); it.nextNode()) {
            count++;
        }
        return count;
    }

    /*public int count() {
        return countLocal(this, 0);
    }

    private int countLocal(HTMLNodeImpl node, int count) {
        for( ; node != null; node = node.next) {
            count++;
            try {
                if ( node instanceof HTMLCompositeNodeImpl )
                    count = countLocal((HTMLNodeImpl)node.getFirstChild(), count);
            }
            catch (NodeNotFoundException ex) {
            }
        }
        return count;
    }*/

    /*public HTMLElement findElement(String id) throws NodeNotFoundException {
        for(NodeTreeIterator it = new NodeTreeIterator(this); it.hasNext(); ) {
            HTMLNode node = it.nextNode();
            if ( node instanceof HTMLElement ) {
                String xid = ((HTMLElement)node).getId();
                if ( xid != null && xid.equals(id) ) {
                    return (HTMLElement)node;
                }
            }
        }
        throw new NodeNotFoundException("HTMLCompositeNode.findElement(\""+id+"\")");
    }*/

    public HTMLElement findElement(String id) throws NodeNotFoundException {
        HTMLElement ret = findElementLocal(this, id);
        if ( ret == null )
            throw new NodeNotFoundException("HTMLCompositeNode.findElement(\""+id+"\")");
        return ret;
    }

    private HTMLElement findElementLocal(HTMLNodeImpl element, String id) {
        for(HTMLNodeImpl node=element ; node != null; node = node.next) {
            if ( node instanceof HTMLElement ) {
                String xid = ((HTMLElement)node).getId();
                if ( xid != null && xid.equals(id) ) {
                    return (HTMLElement)node;
                }
            }
            if ( node instanceof HTMLCompositeNodeImpl ) {
                HTMLNodeImpl child = ((HTMLCompositeNodeImpl)node).firstChild;
                if ( child != null ) {
                    HTMLElement ret = findElementLocal(child, id);
                    if ( ret != null )
                        return ret;
                }
            }
        }
        return null;
    }

    public HTMLElement findElementByClass(String className)
            throws NodeNotFoundException {
        HTMLElement ret = NodeSelector.getElementByClass(new NodeTreeIterator(this), className);
        if ( ret == null )
            throw new NodeNotFoundException();
        return ret;
    }
}
