/*
 * $Id: CheckBox.java,v 1.2 2006/04/27 13:48:09 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/12/17
 */
package feat2.template.form;

import java.util.ArrayList;
import java.util.List;

import feat2.template.HTMLElement;

/**
 * tH[̃`FbN{bNXB
 * @author SUGIMOTO Ken-ichi
 */
public class CheckBox implements FormControl {

    private HTMLElement[] elements;

    CheckBox(HTMLElement[] elements) {
        this.elements = elements;
    }

    /**
     * OLĂ`FbN{bNX̗vfԂB
     * @return
     */
    public HTMLElement[] getElements() {
        return elements;
    }

    /**
     * Iꂽ`FbN{bNXԂB
     * @return vf̔zBIꂽ`FbN{bNXȂꍇ͋̔zԂB
     */
    public HTMLElement[] getSelectedElements() {
        List list = new ArrayList();
        for(int i=0; i<elements.length; i++) {
            if ( elements[i].hasAttribute("checked") ) {
                list.add(elements[i]);
            }
        }
        return (HTMLElement[])list.toArray(new HTMLElement[list.size()]);
    }

    public void setValue(String value) {

        // valueƓȂchecked

        for(int i=0; i<elements.length; i++) {

            String attrVal = elements[i].getAttribute("value");
            if ( attrVal != null && value != null && attrVal.equals(value) ) {
                elements[i].setAttribute("checked", null);
            }

        }

    }

    public void setValues(String[] values) {

        // ׂăNA

        for(int i=0; i<elements.length; i++) {
            elements[i].removeAttribute("checked");
        }

        // l͂

        if ( values != null && values.length > 0 )
            for(int i=0; i<values.length; i++)
                setValue(values[i]);
    }

    public String getValue() {
        String[] values = getValues();
        if ( values.length > 0 )
            return values[0];
        else
            return null;
    }

    public String[] getValues() {
        HTMLElement[] selected = getSelectedElements();
        List list = new ArrayList();
        for(int i=0; i<selected.length; i++) {
            list.add(selected[i].getValue());
        }
        return (String[])list.toArray(new String[list.size()]);
    }

    public HTMLElement getElement() {
        if ( elements.length > 0 )
            return elements[0];
        else
            return null;
    }

    public int getType() {
        return TYPE_CHECKBOX;
    }

}
