/*
 * $Id: RedirectResponse.java,v 1.11 2006/06/01 09:02:09 sugimotokenichi Exp $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/03/17
 */
package feat2.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

import feat2.CommandContext;
import feat2.FeatRuntimeException;
import feat2.FileUploadException;
import feat2.Processor;
import feat2.PropertyAccessException;
import feat2.Response;
import feat2.StringUtil;
import feat2.config.RedirectConfig;

/**
 * _CNgB
 * @author SUGIMOTO Ken-ichi
 */
public class RedirectResponse implements Response {

    private RedirectConfig config;


    public RedirectResponse(RedirectConfig config) {
        this.config = config;
    }


    public String output(CommandContext ctx)
            throws IOException, PropertyAccessException, FileUploadException {

        // ͒l

        Map inputs = Processor.processInputs(config, ctx);

        // _CNg

        if ( config.getMethod().equalsIgnoreCase("get") ) {

            // GET\bhŃ_CNgꍇ

            redirectGet(config.getUri(), inputs, ctx);

        }

        else if ( config.getMethod().equalsIgnoreCase("post") ) {

            // POST\bhŃ_CNgꍇ

            redirectPost(config.getUri(), inputs, ctx);

        }

        else {

            // ݒt@C̃of[VŌĂ̂łւ͗Ȃ͂

            throw new FeatRuntimeException("");
        }

        return null;

    }


    public static void redirectGet(String uri, Map inputs, CommandContext ctx) throws UnsupportedEncodingException, IOException {

        String encoding = getEncoding(ctx);
        String query = null;
        StringBuffer queryBuf = new StringBuffer();

        if ( uri.indexOf('#') > -1 )
            uri = uri.substring(0, uri.indexOf('#'));

        if ( uri.indexOf('?') > -1 ) {
            query = uri.substring(uri.indexOf('?')+1);
            uri = uri.substring(0, uri.indexOf('?'));

            if ( query != null )
                queryBuf.append(query);
        }

        // NG[č\z

        ArrayList queryList = new ArrayList(inputs.size()*2);

        // ͒lXgɒǉ

        for (Iterator keys = inputs.keySet().iterator(); keys.hasNext();) {
            String key = (String)keys.next();
            String encKey = URLEncoder.encode(key, encoding);
            String[] value = toStringArray(inputs.get(key));

            for (int i = 0; i < value.length; i++) {
                queryList.add(new String[] {encKey, URLEncoder.encode(value[i], encoding)});
            }
        }

        // XgNG[ɕϊ

        for(Iterator it=queryList.iterator(); it.hasNext(); ) {

            String[] pair = (String[])it.next();

            if ( queryBuf.length() > 0 ) {
                queryBuf.append('&');
            }

            queryBuf.append(pair[0]);
            queryBuf.append('=');

            if ( pair[1] != null && pair[1].length() > 0 ) {
                queryBuf.append(pair[1]);
            }

        }

        // _CNg

        String newUri = uri;
        if ( queryBuf.length() > 0 )
            newUri = newUri + "?" + queryBuf.toString();
        ctx.getResponse().sendRedirect(newUri);

    }


    public static void redirectPost(String uri, Map inputs, CommandContext ctx) throws IOException, UnsupportedEncodingException {

        String encoding = getEncoding(ctx);
        StringBuffer html = new StringBuffer();
        StringBuffer form = new StringBuffer();

        html.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" ");
        html.append("\"http://www.w3.org/TR/html4/strict.dtd\">\n");
        html.append("<html><head>");
        html.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=");
        html.append(encoding);
        html.append("\">\n");

        // tH[submitJavaScript

        html.append("<script type=\"text/javascript\">\n<!--\n");
        html.append("function submitForm() {\n");
        html.append("    document.forms[0].submit();\n");
        html.append("}\n//-->\n</script></head>\n");

        // tH[

        form.append("<form name=\"form0\" method=\"post\" action=\"");
        form.append(uri);
        form.append("\">\n");

        for(Iterator it=inputs.keySet().iterator(); it.hasNext(); ) {

            String key = (String)it.next();
            String[] val = toStringArray(inputs.get(key));

            if ( val.length == 1 ) {

                form.append("<textarea name=\"").append(StringUtil.escapeHTMLText(key)).append("\">");
                form.append(StringUtil.escapeHTMLText(val[0]));
                form.append("</textarea>\n");

            }

            else if ( val.length > 1 ) {

                for (int i = 0; i < val.length; i++) {

                    // tH[̗vf

                    form.append("<input type=\"checkbox\" name=\"");
                    form.append(StringUtil.escapeHTMLText(key));
                    form.append("\" value=\"");
                    form.append(StringUtil.escapeHTMLText(val[i]));
                    form.append("\" checked>\n");

                }

            }

        }

        form.append("</form>\n");

        // bodyvf

        html.append("<body onLoad=\"submitForm();\"><div style=\"display: none\">");
        html.append(form);
        html.append("</div></body></html>");

        // o

        ctx.getResponse().setContentType("text/html; charset="+encoding);
        OutputStream out = ctx.getResponse().getOutputStream();
        out.write(html.toString().getBytes(encoding)); // FIXME configŏo̓GR[fBOwł悤ɂBwȂ̂Ƃ̓tB[`[Őݒ肳ꂽGR[fBO
        out.flush();
        out.close();
    }


    /**
     * tB[`[Ŏw肳ꂽGR[fBOԂB
     * tB[`[ŃGR[fBOw肳ĂȂUTF-8ԂB
     * @param ctx
     * @return
     */
    private static String getEncoding(CommandContext ctx) {
        String encoding = ctx.getCurrentFeatureConfig().getEncoding();
        if ( encoding == null )
            encoding = "UTF-8";
        return encoding;
    }


    /**
     * IuWFNg𕶎̔zɕϊB
     * @param o
     * @return
     */
    private static String[] toStringArray(Object o) {

        String[] ret;

        if ( o == null )
            return new String[0];

        if ( o instanceof String[] ) {
            return (String[])o;
        }

        else if ( o.getClass().isArray() ) {

            Object[] array = (Object[])o;
            ret = new String[array.length];
            for (int i = 0; i < array.length; i++) {
                ret[i] = array[i].toString();
            }

        }

        else {
            ret = new String[] {o.toString()};
        }

        return ret;

    }
}
