/*
 * $Id: FetchConfig.java,v 1.2 2006/06/06 10:53:23 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2006/02/20
 */
package feat2.config;

import feat2.Action;
import feat2.FeatError;
import feat2.FeatErrors;
import feat2.Fetcher;

/**
 * tFb`R|[lg̐ݒ
 * @author SUGIMOTO Ken-ichi
 */
public class FetchConfig extends ActionConfigBase {

    private long cache;

    public FetchConfig() {
        cache = 0L;
    }


    // vpeB -------------------------------------------------------------

    public long getCache() {
        return cache;
    }
    public void setCache(long cache) {
        this.cache = cache;
    }



    // Config̃\bh -------------------------------------------------------

    public String getElementName() {
        return "fetch";
    }

    public Action getActionInstance() {

        try {

            return (Action) getActionClass().newInstance();

        }
        catch (InstantiationException ex) {
            throw new ConfigurationException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ConfigurationException(ex);
        }

    }

    public boolean validate(FeatErrors errs) {

        boolean ret = super.validate(errs);

        if ( !Fetcher.class.isAssignableFrom(getActionClass()) ) {
            ret = false;
            errs.add( new ConfigError(getClassName().getValue(), "class", ConfigError.TYPE_FETCHER_INTERFACE, FeatError.ERROR, this) );
        }

        if ( cache < 0L ) {
            errs.add(new ConfigError(Long.toString(cache), "error.config.fetch.cache", FeatError.ERROR, this));
            ret = false;
        }

        return ret;
    }

}
