/*
 * $Id: Config.java,v 1.3 2006/04/20 15:30:44 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2006/02/17
 */
package feat2.config;

import feat2.FeatErrors;
import feat2.config.type.Identifier;


/**
 * ݒ̊{NXB
 * @author SUGIMOTO Ken-ichi
 */
abstract public class Config {

    private Config parent;
    //private ErrorHandler errorHandler;

    // vpeB -------------------------------------------------------------

    public Config getParent() {
        return parent;
    }
    public void setParent(Config parent) {
        this.parent = parent;
    }

    /**
     * ݒt@C̗vfԂB
     */
    abstract public String getElementName();

    /**
     * ݒm[h̃CX^X̖OԂB
     * @return OꍇnullԂ
     */
    abstract public Identifier getName();

    // CX^X\bh ---------------------------------------------------

    /*public void handleError(String errorCode) {
        errorHandler.handleError(errorCode, getConfigPath());
    }*/

    /**
     * FeatConfig̃CX^XB
     * @return FeatConfig̃CX^XBȂnullB
     */
    public FeatConfig getFeatConfig() {
        return (FeatConfig)getConfig(FeatConfig.class);
    }

    public FeatureConfig getFeatureConfig() {
        return (FeatureConfig)getConfig(FeatureConfig.class);
    }

    private Config getConfig(Class type) {
        for(Config cur = this; cur != null; cur = cur.getParent()){
            if ( cur instanceof Config && type.isInstance(cur) )
                return (Config)cur;
        }
        return null;
    }

    /**
     * ̐ݒIuWFNg̃c[̈ʒu\ԂB
     * @return
     */
    public String getConfigPath() {
        StringBuffer buf = new StringBuffer();
        for(Config cur = this; cur != null; cur = cur.getParent()) {

            if ( buf.length() > 0 )
                buf.insert(0, "/");

            StringBuffer elembuf = new StringBuffer();
            elembuf.append(cur.getElementName());

            if ( cur.getName() != null ) {
                elembuf.append("[").append(cur.getName().getValue()).append("]");
            }

            buf.insert(0, elembuf.toString());

            if ( cur instanceof FeatConfig || cur instanceof FeatureRootConfig )
                break;

        }
        return buf.toString();
    }

    /*public void setErrorHandler(ErrorHandler handler) {
        errorHandler = handler;
    }*/

    abstract public boolean validate(FeatErrors errs);

}
