/*
 * $Id: ObjectUtil.java,v 1.2 2006/10/09 06:37:23 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/03/23
 */
package feat2;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.PropertyUtilsBean;

import feat2.config.type.Identifier;
import feat2.config.type.IdentifierConverter;
import feat2.config.type.IdentifierList;
import feat2.config.type.IdentifierListConverter;
import feat2.config.type.JavaIdentifier;
import feat2.config.type.JavaIdentifierConverter;
import feat2.config.type.ObjectRef;
import feat2.config.type.ObjectRefConverter;
import feat2.config.type.Scope;
import feat2.config.type.ScopeConverter;

/**
 * IuWFNg̑̂߂̃[eBeBNXB
 * @author SUGIMOTO Ken-ichi
 */
public class ObjectUtil {

    private static ConvertUtilsBean convertUtils = new ConvertUtilsBean();
    private static PropertyUtilsBean propUtils = new PropertyUtilsBean();
    private static BeanUtilsBean beanutils = new BeanUtilsBean(convertUtils, propUtils);

    static {

        setFeatConverters(convertUtils);

    }


    /**
     * NX[hB
     * nameŎw肳ꂽOSCƂă[h݂āAȂnamȇO
     * pbP[Wtă[h݂B
     * ftHgpbP[Wɓ̃NXƂ炪D悳Ă܂߁AftHgpbP[Wɂ
     * NX܂߂ȂقǂB
     * [hɂ́ÃNX[hNX[_gB
     * @param name [hNX̖OBpkgw肵Ȃꍇ͊SC
     * @param pkg pbP[WBnullłǂ
     * @throws ClassNotFoundException
     * @return Class
     */
    public static Class loadClass(String name, String pkg) throws
            ClassNotFoundException {
        // ̃`FbN
        if ( pkg == null )
            pkg = "";
        if ( name == null )
            throw new ClassNotFoundException("NXnull");

        ClassLoader loader = ObjectUtil.class.getClassLoader();//Thread.currentThread().getContextClassLoader();
        Class ret = null;
        try {
            ret = loader.loadClass(name);
        }
        catch (ClassNotFoundException ex) {
            // ȂpbP[WtĒTĂ݂
            if ( pkg.length() > 0 ) {
                name = pkg + "." + name;
                ret = loader.loadClass(name);
            }
        }

        return ret;
    }

    /**
     * ̔zK؂Ȍ^ɕϊăRXgN^ĂяoB
     * @param clazz Class
     * @param args String[]
     * @return Object
     */
    public static Object newInstance(Class clazz, String[] args) throws
            NoSuchMethodException, InvocationTargetException,
            IllegalArgumentException, IllegalAccessException,
            InstantiationException {
        if ( clazz == null || args == null )
            throw new IllegalArgumentException("null");

        // RXgN^T
        // ̐argsƓ̂T
        Constructor[] constructors = clazz.getConstructors();
        Constructor cons = null;
        for(int i=0; i<constructors.length; i++) {
            if ( constructors[i].getParameterTypes().length == args.length )
                cons = constructors[i];
        }

        if ( cons != null ) {
            // nꂽRXgN^̌^ɕϊ
            Class[] types = cons.getParameterTypes();
            Object[] params = new Object[args.length];
            for(int i=0; i<args.length; i++) {
                params[i] = ConvertUtils.convert(args[i], types[i]);
            }
            return cons.newInstance(params);
        }
        throw new NoSuchMethodException(clazz.getName()+"ɂ͈"+args.length+"̃RXgN^͒`ĂȂ");
    }

    /**
     * IuWFNg̃vpeB̒l擾B
     * @param bean Object
     * @param name vpeBBlXgOCfbNXA}bvwłB
     * @return Object
     */
    public static Object getProperty(Object bean, String name) throws
            NoSuchMethodException, InvocationTargetException,
            IllegalAccessException {
        return PropertyUtils.getProperty(bean, name);
    }

    public static void setProperty(Object bean, String name, Object value)
            throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {

        PropertyUtils.setProperty(bean, name, value);
    }

    /**
     * XĝׂẴIuWFNgnamevpeBvalueZbgB
     * @param list
     * @param name
     * @param value
     * @throws NoSuchMethodException
     * @throws InvocationTargetException
     * @throws IllegalAccessException
     */
    public static void setProperty(List list, String name, Object value)
            throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {

        for(int i=0; i<list.size(); i++) {
            setProperty(list.get(i), name, value);
        }
    }

    public static Class getPropertyType(Object bean, String name)
            throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {

        return PropertyUtils.getPropertyType(bean, name);
    }


    public static void populate(Object bean, Map values) throws IllegalAccessException, InvocationTargetException {
        try {
            beanutils.populate(bean, values);
        }
        catch(ConversionException ex) {
            // TODO Ro[gɎsƂ̗O
        }
    }

    /**
     * ConvertUtilsBeanfeať^ւ̃Ro[^ǉB
     * @param convertUtils
     */
    public static void setFeatConverters(ConvertUtilsBean convertUtils) {

        convertUtils.register(new IdentifierConverter(), Identifier.class);
        //convertUtils.register(new IdentifierArrayConverter(), new Identifier[0].getClass());
        convertUtils.register(new IdentifierListConverter(), IdentifierList.class);
        convertUtils.register(new JavaIdentifierConverter(), JavaIdentifier.class);
        convertUtils.register(new ObjectRefConverter(), ObjectRef.class);
        convertUtils.register(new ScopeConverter(), Scope.class);

    }


    /**
     * IuWFNgMapC^tF[XŃbvIuWFNgԂB
     * @param bean
     * @return
     */
    public static Map getBeanMap(Object bean) {
        return new BeanMap(bean);
    }


}
