/*
 * $Id: DOMElementImpl.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/10/30
 */
package feat2.template.impl;

import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import feat2.template.NodeSelector;
import feat2.template.NodeTreeIterator;

/**
 * DOM APIElement̎B
 * @author SUGIMOTO Ken-ichi
 */
public class DOMElementImpl extends DOMNodeImpl implements Element {

    public DOMElementImpl(HTMLElementImpl htmlNode) {
        super(htmlNode);
    }

    private HTMLElementImpl getHTMLElement() {
        return (HTMLElementImpl)convertHTML();
    }

    // Node̎

    public NamedNodeMap getAttributes() {
        return getHTMLElement().getAttributes();
    }

    public String getLocalName() {
        return getHTMLElement().getTagName();
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public boolean hasAttributes() {
        return getHTMLElement().hasAttribute();
    }

    public void setNodeValue(String nodeValue) throws DOMException {
    }

    // Element̎

    public short getNodeType() {
        return Node.ELEMENT_NODE;
    }

    public String getNodeName() {
        return getTagName();
    }

    public String getTagName() {
        return getHTMLElement().getTagName();
    }

    public void removeAttribute(String name) throws DOMException {
        throw new DOMException(DOMException.NOT_SUPPORTED_ERR, "");
    }

    public boolean hasAttribute(String name) {
        return getHTMLElement().hasAttribute();
    }

    public String getAttribute(String name) {
        //log.info("attr:"+name);
        return getAttributeNode(name).getValue();
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(DOMException.NOT_SUPPORTED_ERR, "");
    }

    public void setAttribute(String name, String value) throws DOMException {
        throw new DOMException(DOMException.NOT_SUPPORTED_ERR, "");
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        if ( namespaceURI == null )
            return hasAttribute(localName);
        else
            return false;
    }

    public Attr getAttributeNode(String name) {
        //log.info("attr:"+name);
        // l[Xy[X͍폜
        if ( name.equalsIgnoreCase("xmlns") )
            return null;
        else
            return (Attr)TemplateUtil.toDomNode(getHTMLElement().getValuedAttribute(name));
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        throw new DOMException(DOMException.NOT_SUPPORTED_ERR, "");
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        throw new DOMException(DOMException.NOT_SUPPORTED_ERR, "");
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        throw new DOMException(DOMException.NOT_SUPPORTED_ERR, "");
    }

    public NodeList getElementsByTagName(String name) {
        //log.info("element:"+name);
        return TemplateUtil.toDomNodeList(NodeSelector.selectTags(new NodeTreeIterator(convertHTML()), name));
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        //log.info("attr:"+localName);
        if ( namespaceURI == null )
            return this.getAttribute(localName);
        else
            return null;
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        throw new DOMException(DOMException.NOT_SUPPORTED_ERR, "");
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        //log.info("attr:"+localName);
        if ( namespaceURI == null )
            return this.getAttributeNode(localName);
        else
            return null;
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        //log.info("element:"+localName);
        if ( namespaceURI == null ) {
            return getElementsByTagName(localName);
        }
        else {
            return new HTMLNodeListImpl();
        }
    }

}
