/*
 * $Id: Cache.java,v 1.2 2006/06/01 08:28:31 sugimotokenichi Exp $
 * Copyright (C) 2004-2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/04/30
 */
package feat2.impl;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;

/**
 * w̎ԂIuWFNgێLbVBput, get, clean\bh
 * CacheCX^XgœB
 * @author SUGIMOTO Ken-ichi
 */
public class Cache {

    private HashMap buf;
    private long cleanTime;

    public Cache() {
        buf = new HashMap();
        cleanTime = 0;
    }


    /**
     * IuWFNgۑB
     * @param key L[
     * @param obj ۑIuWFNg
     * @param ttl IuWFNgۊǂő厞ԁB
     * q[vsƂ͂̎Ԃ葁IuWFNgj邱Ƃ
     */
    synchronized public void put(Object key, Object obj, long ttl) {

        CacheEntry entry = new CacheEntry(obj, ttl);
        buf.put(key, entry);

    }


    /**
     * ۊǂꂽIuWFNgԂB
     * @param key L[
     * @return IuWFNgۊǂĂ΂̎QƁBIuWFNgȂAjĂnull
     */
    synchronized public Object get(Object key) {

        CacheEntry entry = (CacheEntry)buf.get(key);
        if ( entry != null ) {

            Object ret = entry.get();
            if ( ret == null )
                buf.remove(key);
            return ret;

        }

        return null;

    }


    /**
     * LbV̕svȃIuWFNgJBAK[xbWRNV͍sȂB
     * @param interval sԊuBǑĂяo炱̎Ԃo߂ĂȂΏsȂ
     * @param limit sԐB̎Ԃ𒴉߂Ƃ܂IĂȂĂ^[
     */
    synchronized public void clean(long interval, long limit) {

        if ( cleanTime+interval < System.currentTimeMillis() ) {

            long start = cleanTime = System.currentTimeMillis();
            for(Iterator it = buf.keySet().iterator(); it.hasNext(); ) {

                Object key = it.next();
                CacheEntry entry = (CacheEntry)buf.get(key);

                if ( entry != null ) {

                    Object obj = entry.get();
                    if ( obj == null )
                        buf.remove(key);

                    if ( start+limit < System.currentTimeMillis() )
                        break;
                }
                else
                    buf.remove(key);

            }

        }

    }

    private class CacheEntry {

        private long time;
        private long ttl;
        private SoftReference ref;

        private CacheEntry(Object obj, long ttl) {
            ref = new SoftReference(obj);
            this.ttl = ttl;
            this.time = System.currentTimeMillis();
        }

        private Object get() {
            Object ret = ref.get();
            if ( ret != null && time+ttl < System.currentTimeMillis() ) {
                ret = null;
            }

            return ret;
        }

    }
}
