/*
 * $Id: Identifier.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/03/10
 */
package feat2.config.type;

import java.util.regex.Pattern;

import feat2.validation.ValidatorUtil;

/**
 * feat̎ʎqB
 * @author SUGIMOTO Ken-ichi
 */
public class Identifier {

    private String value;

    public Identifier() {
        value = null;
    }

    public Identifier(String identifier) throws IllegalArgumentException {

        if ( !isIdentifier(identifier) ) {
            throw new IllegalArgumentException(); // TODO G[bZ[W
        }

        this.value = identifier;
    }



    // Object̃\bh

    public boolean equals(Object obj) {
        return value.equals( ((Identifier)obj).getValue() );
    }

    public int hashCode() {
        return value.hashCode();
    }

    public String toString() {
        return value;
    }



    // vpeB -------------------------------------------------------------

    public String getValue() {
        return value;
    }

    // X^eBbN\bh ---------------------------------------------------

    /**
     * featʎqȂtrueԂB
     * @param string
     * @return
     */
    public static boolean isIdentifier(String string) {

        // ܂܂Ȃfalse

        if ( ValidatorUtil.isBlankOrNull(string) )
            return false;

        return identifierPattern.matcher(string).matches();

    }
    private static Pattern identifierPattern = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*$");



}
