/*
 * $Id: InterceptConfig.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2006/02/20
 */
package feat2.config;

import feat2.FeatErrors;
import feat2.Interceptor;
import feat2.StringUtil;
import feat2.config.type.Identifier;
import feat2.config.type.JavaIdentifier;

/**
 * C^[Zvg̐ݒB
 * @author SUGIMOTO Ken-ichi
 */
public class InterceptConfig extends Config {

    private JavaIdentifier className;
    private String pattern;


    // validation\bĥƂŗLɂȂϐ -------------------------------

    private Class interceptorClass;
    private String[] patterns;


    // vpeB -------------------------------------------------------------

    public JavaIdentifier getClassName() {
        return className;
    }
    public void setClassName(JavaIdentifier className) {
        this.className = className;
    }

    public String getPattern() {
        return pattern;
    }
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String[] getPatterns() {
        return patterns;
    }

    public Identifier getName() {
        return null;
    }


    // CX^X\bh ---------------------------------------------------

    public Interceptor getInterceptorInstance() {

        try {

            return (Interceptor)interceptorClass.newInstance();

        }
        catch (InstantiationException ex) {
            throw new ConfigurationException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ConfigurationException(ex);
        }

    }


    // Config̃\bh -------------------------------------------------------

    public String getElementName() {
        return "intercept";
    }

    public boolean validate(FeatErrors errs) {

        boolean ret = true;

        interceptorClass = ConfigUtil.validateClass(className, "class", this, errs);
        if ( interceptorClass == null )
            ret = false;

        if ( ConfigUtil.validateRequired(pattern, "pattern", this, errs) ) {
            patterns = StringUtil.split(pattern);
        }
        else {
            ret = false;
        }

        return ret;

    }


}
