/*
 * $Id: ConfigError.java,v 1.6 2006/05/18 09:38:18 sugimotokenichi Exp $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/03/24
 */
package feat2.config;

import java.util.HashMap;

import feat2.FeatError;
import feat2.FileResourceManager;
import feat2.ResourceManager;
import feat2.StringUtil;

/**
 * ݒeɊԈႢƂ̃G[B
 * @author SUGIMOTO Ken-ichi
 */
public class ConfigError implements FeatError {

    public static final String
        TYPE_NULL = "null",
        TYPE_CLASS_NOT_FOUND_EXCEPTION = "ClassNotFoundException",
        TYPE_INSTANTIATION_EXCEPTION = "InstantiationException",
        TYPE_ILLEGAL_ACCESS_EXCEPTION = "IllegalAccessException",
        TYPE_DATA_INTERFACE = "data_interface",
        TYPE_FILEDOWNLOAD_INTERFACE = "filedownload_interface",
        TYPE_EFFECTOR_INTERFACE = "effector_interface",
        TYPE_FETCHER_INTERFACE = "fetcher_interface",
        TYPE_VIEW_INTERFACE = "view_interface",
        TYPE_INTERCEPTOR_INTERFACE = "interceptor_interface",
        TYPE_REFERRENCE = "referrence",
        TYPE_REFERRENCE_VALIDATION = "referrence.validation",
        TYPE_REFERRENCE_RESPONSE = "referrence.response",
        TYPE_RESOURCE = "resource",
        TYPE_VALUE = "value",
        TYPE_ERROR_RESPONSE = "error_response",
        TYPE_URI_SYNTAX = "error_uri_syntax";


    private String messageId;
    private String featureName;
    private Config componentConfig;
    private int level;
    private ResourceManager rm;
    private HashMap keywords;


    public ConfigError(String value, String messageId, int level, Config config) {

        this.level = level;
        try {
            this.featureName = config.getFeatureConfig().getName().getValue();
        }
        catch (NullPointerException ex) {
            this.featureName = "";
        }
        this.componentConfig = config;
        this.messageId = messageId;

        keywords = new HashMap();
        keywords.put("value", value);
        keywords.put("element", config.getConfigPath());

    }


    public ConfigError(String value, String attributeName, String errorType, int level, Config config) {

        this.level = level;
        try {
            this.featureName = config.getFeatureConfig().getName().getValue();
        }
        catch (NullPointerException ex) {
            this.featureName = "";
        }
        this.componentConfig = config;
        this.messageId = "error.config." + errorType;

        keywords = new HashMap();
        keywords.put("value", value);
        keywords.put("element", config.getConfigPath());
        keywords.put("attr", attributeName);

    }

    public String getMessageId() {
        return messageId;
    }

    public String getFeatureName() {
        return featureName;
    }

    public Config getComponentConfig() {
        return componentConfig;
    }

    public int getErrorLevel() {
        return level;
    }

    public void setResourceManager(ResourceManager rm) {
        this.rm = rm;
    }

    public void addKeyrowd(String key, String value) {
        keywords.put(key, value);
    }

    public String getMessage() throws IllegalStateException {

        ResourceManager resourceManager = rm;

        if ( resourceManager == null ) {
            resourceManager = FileResourceManager.getInstance();
        }

        String message = resourceManager.getStringResource(messageId);

        if ( message == null ) {

            message = messageId;

        }
        else {

            message = StringUtil.replaceParameters(message, keywords);

        }

        return message;
    }


}
