/*
 * $Id: BeanConfig.java,v 1.5 2006/06/01 09:02:10 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2006/02/20
 */
package feat2.config;

import feat2.Action;
import feat2.CommandContext;
import feat2.FeatErrors;
import feat2.FeatRuntimeException;
import feat2.HTTPSessionException;
import feat2.config.type.Scope;


/**
 * Bean̐ݒB
 * @author SUGIMOTO Ken-ichi
 */
public class BeanConfig extends ActionConfigBase {

    //private static Log log = LogFactory.getLog(BeanAction.class);

    private Scope scope;

    // vpeB -------------------------------------------------------------

    public Scope getScope() {
        return scope;
    }
    public void setScope(Scope scope) {
        this.scope = scope;
    }

    // Config̃\bh -------------------------------------------------------

    public String getElementName() {
        return "bean";
    }


    // ActionConfigBasẽ\bh ---------------------------------------------

    public Action getActionInstance() {
        return new BeanAction(getActionClass(), getName().getValue());
    }

    public boolean validate(FeatErrors errs) {

        boolean ret = super.validate(errs);

        // scope

        if ( scope == null )
            scope = new Scope("local");

        return ret;

    }


    // NX -------------------------------------------------------------

    public class BeanAction implements Action {

        private Class beanClass;
        private String beanName;
        private Object bean;

        /**
         * @param beanClass ̃RXgN^ŃCX^X邱ƂmFNXn
         */
        private BeanAction(Class beanClass, String beanName) {
            this.beanClass = beanClass;
            this.beanName = beanName;
        }

        public Object execute(CommandContext ctx) {
            return bean;
        }

        public Object getBean(CommandContext ctx) throws HTTPSessionException {

            bean = ctx.getAttribute(beanName, scope);
            if ( bean == null ) {
                bean = createBeanInstance();
                ctx.setAttribute(beanName, bean, scope);
            }

            return bean;

        }

        private Object createBeanInstance() {

            try {
                return beanClass.newInstance();
            }
            catch (InstantiationException ex) {
                throw new FeatRuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new FeatRuntimeException(ex);
            }

        }

    }

}
