/*
 * $Id: FeatRuntimeException.java,v 1.4 2006/10/11 13:46:15 sugimotokenichi Exp $
 * Copyright (C) 2005-2006 SUGIMOTO Ken-ichi
 * 쐬: 2005/07/30
 */
package feat2;

import java.util.HashMap;

/**
 * {N͂̂Ȃ󋵂̂ƂɓOB
 * @author SUGIMOTO Ken-ichi
 */
public class FeatRuntimeException extends RuntimeException {

    private static final long serialVersionUID = "$Id: FeatRuntimeException.java,v 1.4 2006/10/11 13:46:15 sugimotokenichi Exp $".hashCode();

    private String messageId;
    private HashMap keywords;


    public FeatRuntimeException() {
        super();
        keywords = new HashMap();
    }

    public FeatRuntimeException(String messageId, Throwable cause) {
        super(cause);
        this.messageId = messageId;
        keywords = new HashMap();
    }

    public FeatRuntimeException(String messageId) {
        super();
        this.messageId = messageId;
        keywords = new HashMap();
    }

    public FeatRuntimeException(Throwable cause) {
        super(cause);
        keywords = new HashMap();
    }


    public String getMessageId() {
        return messageId;
    }


    /**
     * bZ[W̃L[[huǉB
     * @param key
     * @param word
     */
    public void addKeyword(String key, String word) {
        keywords.put(key, word);
    }


    /**
     * bZ[WIDɑΉG[bZ[WԂB
     * \[X}l[W̓ftHgFileResourceManagergB
     * \[XȂƂ̓\[XIDԂB
     */
    public String getMessage() {

        String message = null;
        if ( messageId != null )
            message = FileResourceManager.getInstance().getStringResource(messageId);

        if ( message == null )
            return messageId;

        message = StringUtil.replaceParameters(message, keywords);
        return message;

    }

}
