/*
 * $Id: FeatException.java,v 1.5 2006/10/11 13:46:15 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 */

package feat2;

import java.util.HashMap;

public class FeatException extends Exception {

    private static final long serialVersionUID = "$Id: FeatException.java,v 1.5 2006/10/11 13:46:15 sugimotokenichi Exp $".hashCode();

    private String messageId;
    private HashMap keywords;


    public FeatException() {
        super();
        keywords = new HashMap();
    }

    public FeatException(String messageId, Throwable cause) {
        super(cause);
        this.messageId = messageId;
        keywords = new HashMap();
    }

    public FeatException(String messageId) {
        super();
        this.messageId = messageId;
        keywords = new HashMap();
    }

    public FeatException(Throwable cause) {
        super(cause);
        keywords = new HashMap();
    }


    public String getMessageId() {
        return messageId;
    }


    /**
     * bZ[W̃L[[huǉB
     * @param key
     * @param word
     */
    public void addKeyword(String key, String word) {
        keywords.put(key, word);
    }


    /**
     * bZ[WIDɑΉG[bZ[WԂB
     * \[X}l[W̓ftHgFileResourceManagergB
     * \[XȂƂ̓\[XIDԂB
     */
    public String getMessage() {

        String message = null;
        if ( messageId != null )
            message = FileResourceManager.getInstance().getStringResource(messageId);

        if ( message == null )
            return messageId;

        message = StringUtil.replaceParameters(message, keywords);
        return message;

    }


}
