/*
 * $Id: CommandContext.java,v 1.14 2006/06/01 08:28:32 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2006/03/01
 */
package feat2;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

import feat2.config.CommandConfig;
import feat2.config.ConfigurationException;
import feat2.config.FeatConfig;
import feat2.config.FeatureConfig;
import feat2.config.type.Scope;
import feat2.impl.Cache;

/**
 * R}hs̃ReNXgBCtTCN̓NGXgƂقړA
 * NGXgtH[hꂽƂ̓tH[hŐVReNXgB
 * @author SUGIMOTO Ken-ichi
 */
public class CommandContext implements ResourceManager {

    //private static Log log = LogFactory.getLog(ActionContext.class);
    private static Cache localCache;

    static {
        localCache = new Cache();
    }

    private FeatConfig config;
    private FeatureConfig featureConfig;
    private CommandConfig commandConfig;
    private FeatErrors featureErrors;
    private HashMap attributes;
    private String featureName;
    private String commandName;
    private String outputName;
    private Throwable exception;

    private ServletContext servletContext;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private HashMap multipartItems;


    public CommandContext(FeatConfig config, ServletContext servletContext,
            HttpServletRequest request,
            HttpServletResponse response) throws HttpNotFoundException {

        this.config = config;
        this.servletContext = servletContext;
        this.request = request;
        this.response = response;
        featureErrors = new FeatErrors(this);
        attributes = new HashMap();

        // NGXgURIFeatureAR}ho

        String servletPath = request.getServletPath();

        if ( servletPath != null ) {

            String[] pathInfo = StringUtil.split(servletPath, "/");
            if ( pathInfo.length > 0 )
                featureName = pathInfo[0];
            if ( pathInfo.length > 1 )
                commandName = StringUtil.substringBefore(pathInfo[1], ".");

        }

        if ( featureName == null ) {
            throw new HttpNotFoundException("exception.CommandContext.featureName.notfound");
        }
        else {
            featureConfig = config.getFeatureConfig(featureName);
            if ( featureConfig == null ) {
                HttpNotFoundException ex = new HttpNotFoundException("exception.CommandContext.feature.notfound");
                ex.addKeyword("name", featureName);
                throw ex;
            }
        }

        if ( commandName == null ) {
            throw new HttpNotFoundException("exception.CommandContext.commandName.notfound");
        }
        else {
            commandConfig = featureConfig.getCommandConfig(commandName);
            if ( commandConfig == null ) {
                HttpNotFoundException ex = new HttpNotFoundException("exception.CommandContext.command.notfound");
                ex.addKeyword("name", commandName);
                throw ex;
            }
        }

        // NGXgp[^̃GR[fBO

        String encoding = getEncoding();
        if ( encoding != null )
            try {
                request.setCharacterEncoding(encoding);
            }
            catch (UnsupportedEncodingException ex) {
                throw new ConfigurationException(ex);
            }
    }

    public HttpServletRequest getRequest() {
        return request;
    }

    /**
     * multipart/form-datãNGXg{߂ĕԂB
     * ̃\bh̓AvP[VHttpServletRequestgetParameter\bh
     * getInputStream\bhAgetReader\bhĂяoƂł͓삵ȂB
     * @return NGXg{̃}bvMap&lt;String, MultipartFormItem&gt;BNGXg{multipart/form-datałȂƂnullԂB
     * @throws feat2.FileUploadException NGXg{̃p[Xɖ肪NƂ
     */
    public Map getMultipartRequestBody() throws feat2.FileUploadException {

        if ( multipartItems != null )
            return multipartItems;

        if ( !isMultipartRequest() )
            return null;

        multipartItems = new HashMap();

        FileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload(factory);
        List items;
        try {
            items = upload.parseRequest(request);
        }
        catch (FileUploadException ex) {
            throw new feat2.FileUploadException(ex);
        }

        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            FileItem item = (FileItem) iter.next();

            MultipartFormItem formItem = new MultipartFormItem(item);

            multipartItems.put(formItem.getFieldName(), formItem);

        }

        return multipartItems;

    }


    /**
     * HTTPNGXg}`p[gNGXgǂԂB
     */
    public boolean isMultipartRequest() {

        return multipartItems != null ||
            ( request.getMethod().equalsIgnoreCase("POST") &&
              request.getContentType().indexOf("multipart/form-data") > -1 );

    }


    public class MultipartFormItem {

        private FileItem item;

        private MultipartFormItem(FileItem item) {
            this.item = item;
        }

        public String getContentType() {
            return item.getContentType();
        }

        public String getFieldName() {
            return item.getFieldName();
        }

        public String getFileName() {
            return item.getName();
        }

        public long getSize() {
            return item.getSize();
        }

        /**
         * tB[h̓eԂB
         * GR[fBOcommand܂featureencodingŐݒ肳ꂽlAftHgGR[fBOB
         * @return
         */
        public String getString() {
            String encoding = getEncoding();
            if ( encoding == null )
                encoding = System.getProperty("file.encoding");
            try {
                return item.getString(encoding);
            }
            catch (UnsupportedEncodingException ex) {
                throw new FeatRuntimeException(ex);
            }
        }

        public boolean isFormField() {
            return item.isFormField();
        }

        public boolean isInMemory() {
            return item.isInMemory();
        }

        public byte[] get() {
            return item.get();
        }

        public File getFile() throws IOException {

            File ret = File.createTempFile("feat_", null);

            try {
                item.write(ret);
            }
            catch (Exception ex) {
                throw new FeatRuntimeException(ex);
            }

            return ret;

        }

    }


    public HttpServletResponse getResponse() {
        return response;
    }

    public ServletContext getServletContext() {
        return servletContext;
    }


    /**
     * R}hReNXgIuWFNgoB
     * @param name
     * @return
     */
    public Object getAttribute(String name) {
        return attributes.get(name);
    }
    /**
     * R}hReNXgɃIuWFNgǉB
     * @param name
     * @param o
     */
    public void setAttribute(String name, Object o) {
        attributes.put(name, o);
    }


    public Object getCacheObject(Object key) {
        return localCache.get(key);
    }
    public void putCacheObject(Object key, Object obj, long ttl) {
        localCache.put(key, obj, ttl);
    }


    public Object getAttribute(String name, Scope scope) {

        Object ret = null;

        switch (scope.getScope() ) {

            case Scope.LOCAL:
                ret = getAttribute(name);
                break;

            case Scope.REQUEST:
                ret = request.getAttribute(name);
                break;

            case Scope.USER:
                // TODO USERReNXg̃IuWFNgQ
                break;

            case Scope.SESSION:
                try {
                    ret = getSession().getAttribute(name);
                }
                catch (NullPointerException ex) {
                }
                break;

            case Scope.APPLICATION:
                ret = servletContext.getAttribute(name);
                break;

        }

        return ret;

    }

    public void setAttribute(String name, Object value, Scope scope) throws HTTPSessionException {

        switch (scope.getScope() ) {

            case Scope.LOCAL:
                setAttribute(name, value);
                break;

            case Scope.REQUEST:
                request.setAttribute(name, value);
                break;

            case Scope.USER:
                // TODO USERReNXgɃIuWFNgZbg
                break;

            case Scope.SESSION:
                HttpSession session = getSession();
                if ( session == null )
                    throw new HTTPSessionException("BeanZbg悤Ƃ܂ZbV܂ł "+getCurrentCommandConfig().getConfigPath());
                session.setAttribute(name, value);
                break;

            case Scope.APPLICATION:
                servletContext.setAttribute(name, value);
                break;

        }

    }


    /**
     * GR[fBOCNGXgp[^ԂB
     */
    public String getRequestParameter(String name) {

        String ret = request.getParameter(name);
        String encoding = getEncoding();

        if ( ret != null
                && request.getMethod().equalsIgnoreCase("get")
                && config.isUseBodyEncodingForURI()
                && encoding != null ) {

            try {
                ret = StringUtil.convertEncoding(ret, encoding);
                ret = StringUtil.correctJapaneseChars(ret, encoding);
            }
            catch (UnsupportedEncodingException ex) {
                throw new ConfigurationException(ex);
            }

        }

        return ret;

    }


    /**
     * GR[fBOCNGXgp[^ԂB
     */
    public String[] getRequestParameterValues(String name) {

        String[] ret = request.getParameterValues(name);
        String encoding = getEncoding();

        if ( ret != null
                && request.getMethod().equalsIgnoreCase("get")
                && config.isUseBodyEncodingForURI()
                && encoding != null ) {

            try {
                ret = StringUtil.convertEncoding(ret, encoding);
                for (int i = 0; i < ret.length; i++) {
                    ret[i] = StringUtil.correctJapaneseChars(ret[i], encoding);
                }
            }
            catch (UnsupportedEncodingException ex) {
                throw new ConfigurationException(ex);
            }

        }

        return ret;

    }


    /**
     * GR[fBOCNGXgp[^ԂB
     * @return Map&lt;String, String[]&gt;
     */
    public Map getRequestParameterMap() {

        Map params = request.getParameterMap();
        HashMap ret = new HashMap(params.size());

        String encoding = getEncoding();

        if ( request.getMethod().equalsIgnoreCase("get")
                && config.isUseBodyEncodingForURI()
                && encoding != null ) {

            try {

                for(Iterator it=params.keySet().iterator(); it.hasNext(); ) {

                    String key = (String)it.next();
                    String[] value = (String[])params.get(key);

                    value = StringUtil.convertEncoding(value, encoding);

                    for (int i = 0; i < value.length; i++) {
                        value[i] = StringUtil.correctJapaneseChars(value[i], encoding);
                    }

                    ret.put(key, value);

                }

            }
            catch (UnsupportedEncodingException ex) {
                throw new ConfigurationException(ex);
            }

        }

        else {

            ret.putAll(params);

        }

        return ret;

    }




    /**
     * ݒeԂB
     */
    public FeatConfig getFeatConfig() {
        return config;
    }

    /**
     * ZbVԂB
     * @return ZbV܂Ă炸AZbVtOfalsenull
     */
    public HttpSession getSession() {
        Boolean createSession = getCurrentCommandConfig().getCreateSession();
        if ( createSession == null )
            createSession = getCurrentFeatureConfig().getCreateSession();

        HttpSession session = request.getSession(createSession != null && createSession.booleanValue());
        return session;
    }

    /**
     * ݂̃NGXgŎw肳ꂽtB[`[̐ݒԂB
     * @return NGXg̃tB[`[ݒIuWFNgBnull͕ԂȂ
     */
    public FeatureConfig getCurrentFeatureConfig() {
        return featureConfig;
    }

    /**
     * ݂̃NGXgŎw肳ꂽR}h̐ݒԂB
     * @return NGXg̃R}hݒIuWFNgBnull͕ԂȂ
     */
    public CommandConfig getCurrentCommandConfig() {
        return commandConfig;
    }

    public String getCommandName() {
        return commandName;
    }

    public String getFeatureName() {
        return featureName;
    }

    /**
     * ̃NGXg̏ɔG[̃XgԂB
     * @return FeatureErrors
     */
    public FeatErrors getFeatErrors() {
        return featureErrors;
    }

    /**
     * ݂̃GR[fBOݒԂB
     * GR[fBO̓NGXgp[^擾ƂɎQƂB
     * R}hAtB[`[̏ŌBǂɂ`ĂȂƂnullB
     * @return String
     */
    public String getEncoding() {
        String ret = null;

        ret = getCurrentCommandConfig().getEncoding();

        if (ret == null) {
            ret = getCurrentFeatureConfig().getEncoding();
        }

        return ret;
    }

    public String getOutputName() {
        return outputName;
    }
    /**
     * R}h̃AEgvbgݒ肷B
     * @return
     */
    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }

    /**
     * ɋNOԂB
     * @return
     */
    public Throwable getException() {
        return exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    /**
     * ݂̃ReNXg̃P[̃\[XԂB
     * @param name \[X
     * @return String
     */
    public String getStringResource(String name) {
        return getStringResource(getCurrentFeatureConfig(), name);
    }

    /**
     * wtB[`[烊\[X擾B
     * P[HTTPZbVɕۑꂽݒAHTTPwb_Accept-Language瓾ꂽ̂gpB
     * @see #setLocale(Locale)
     * @see #getLocale()
     */
    public String getStringResource(FeatureConfig featureConf, String name) {
        return getStringResource(featureConf, name, getLocale());
    }

    /**
     * \[X擾B
     */
    public String getStringResource(FeatureConfig featureConf, String name, Locale[] locale) {

        for(int i=0;i <locale.length; i++) {
            String ret = getStringResource(featureConf, name, locale[i]);
            if ( ret != null )
                return ret;
        }

        // P[wȂ
        return getStringResource(featureConf, name, Util.NULL_LOCALE);
    }

    /**
     * w̃P[ސ郍P[Ń\[XTB
     * @param featureConf
     * @param resourceName
     * @param sequence
     * @return
     */
    private String getStringResource(FeatureConfig featureConf, String resourceName, Locale locale) {
        String ret = null;

        // P[ސ
        List sequence = null;
        if ( locale != Util.NULL_LOCALE )
            sequence = Util.expandLocale(locale);
        else {
            sequence = new ArrayList();
            sequence.add(Util.NULL_LOCALE);
        }

        // tB[`[̃\[X
        for(int i=0; i<sequence.size(); i++) {
            ret = featureConf.getStringResource(resourceName, (Locale)sequence.get(i));
            if ( ret != null )
                return ret;
        }

        // featݒt@C̃\[X
        for(int i=0; i<sequence.size(); i++) {
            ret = featureConf.getFeatConfig().getStringResource(resourceName, (Locale)sequence.get(i));
            if ( ret != null )
                return ret;
        }

        return null;
    }

    /**
     * ̃ZbṼP[ύXB
     * Őݒ肵P[̓ZbVێێB
     * @param locale
     */
    public void setSessionLocale(Locale locale) {
        try {
            getSession().setAttribute(FeatConst.FEATURE_CONTEXT_LOCALE_KEY, locale);
        }
        catch (NullPointerException ex) {
        }
    }

    /**
     * ݂̃XR[ṽP[擾B
     * P[̌ ZbV -> HTTPwb_(Accept-Language) -> JVM̃ftHgP[B
     * @return
     */
    public Locale[] getLocale() {
        Locale[] ret = null;

        // ZbVɐݒ肳ꂽP[擾B

        try {

            Locale sessionLocale = (Locale)getSession().getAttribute(FeatConst.FEATURE_CONTEXT_LOCALE_KEY);
            if ( sessionLocale != null )
                ret = new Locale[] {sessionLocale};

        }
        catch (NullPointerException ex) {
        }

        // ZbVɃP[ݒ肳ĂȂꍇHTTPwb_̌w擾B

        if ( ret == null && request != null ) {

            if ( ret == null && request != null ) {

                String acceptLanguage = request.getHeader("Accept-Language");
                if ( acceptLanguage != null && acceptLanguage.length() > 0 ) {

                    LanguageRange[] languageRange = parseLanguageRange(acceptLanguage);

                    if ( languageRange.length > 0 ) {
                        ret = new Locale[languageRange.length];

                        for(int i=0; i<languageRange.length; i++) {
                            ret[i] = languageRange[i].lang;
                        }
                    }
                }
            }
        }

        if ( ret == null )
            ret = new Locale[] {Locale.getDefault()};

        return ret;
    }

    private LanguageRange[] parseLanguageRange(String str) {
        String list[] = StringUtil.stripAll(StringUtil.split(str, ","));
        LanguageRange[] ret = new LanguageRange[list.length];
        for(int i=0; i<list.length; i++) {
            ret[i] = new LanguageRange(list[i], i);
        }
        Arrays.sort(ret);
        return ret;
    }


    private class LanguageRange implements Comparable {
        Locale lang;
        double quality;
        int index;

        LanguageRange(String str, int index) {
            this.index = index;

            if ( str == null || str.length() == 0 ) {
                lang = null;
                quality = 0.0D;
                return;
            }

            String[] part = StringUtil.stripAll(StringUtil.split(str, ";"));
            if ( part.length != 0 ) {
                lang = parseLang(part[0]);
                if ( part.length > 1 ) {
                    String[] token = StringUtil.stripAll(StringUtil.split(part[1], "="));
                    if ( token.length > 1 ) {
                        quality = parseQuality(token[1]);
                    }
                }
                else {
                    quality = 1.0D;
                }
            }
        }

        private Locale parseLang(String str) {
            Locale ret = null;
            if ( str != null && str.length() > 0 ) {
                String[] l = StringUtil.split(str, "-");
                if ( l.length == 1 ) {
                    ret = new Locale(l[0].toLowerCase());
                }
                else if ( l.length >= 2 ) {
                    ret = new Locale(l[0].toLowerCase(), l[1].toUpperCase());
                }
            }
            return ret;
        }

        private double parseQuality(String token) {
            try {
                return Double.parseDouble(token);
            }
            catch (NumberFormatException ex) {
                return 0.0D;
            }
        }

        public int compareTo(Object o) {
            return -compareTo_(o);
        }

        private int compareTo_(Object o) {
            LanguageRange oo = (LanguageRange)o;
            if ( quality < oo.quality )
                return -1;
            if ( quality > oo.quality )
                return 1;

            if ( index < oo.index )
                return -1;
            if ( index > oo.index )
                return 1;

            return 0;
        }
    }
}
