fcf.module({
  name: "fcf:tests/getVariablesString.test.js",
  dependencies: ["fcf:NTest/uniTest.js"],
  module: function(uniTest) {
    uniTest.add("005 base" , "getVariablesString", function(a_tester) {
      uniTest.equal(
        fcf.getVariablesString("${{test}}$"),
        ["test"]
      );
      uniTest.equal(
        fcf.getVariablesString("asdhkas${{test}}$ jsad jaksd;la"),
        ["test"]
      );
      uniTest.equal(
        fcf.getVariablesString("asdhkas${{test}}$"),
        ["test"]
      );
      uniTest.equal(
        fcf.getVariablesString("${{test}}$asdhkas"),
        ["test"]
      );
      uniTest.equal(
        fcf.getVariablesString("asd#{{test}}#asd"),
        ["test"]
      );
      uniTest.equal(
        fcf.getVariablesString("asd@{{test}}@asd"),
        ["test"]
      );
      uniTest.equal(
        fcf.getVariablesString("asd@{{test/2}}@asd"),
        ["test"]
      );
      uniTest.equal(
        fcf.getVariablesString("asd@{{test.args.first/tets1}}@asd"),
        ["test.args.first", "tets1"]
      );
      uniTest.equal(
        fcf.getVariablesString("asd@{{test['args']['first'] / tets1}}@asd"),
        ["test['args']['first']", "tets1"]
      );
      uniTest.equal(
        fcf.getVariablesString("asd@{{test[\"args\"]['first'] / tets1}}@asd"),
        ["test[\"args\"]['first']", "tets1"]
      );
    });
  }
});
