var fs = require('fs');

fcf.module({
  name: "fcf:NServer/NControllers/Settings.js",
  dependencies: ["fcf:NServer/NControllers/Controller.js"],
  module: function(Controller) {
    fcf.prepareObject(fcf, "NServer.NControllers");

    var resultContext = false;

    fcf.NServer.NControllers.Settings = class Settings extends Controller{

      action(a_request) {
        let self = this;
        a_request.setHeader("Content-Type", "application/javascript");
        if (!resultContext)
          resultContext = "fcf.application.setEnvironment(" + 
                          JSON.stringify({
                            aliases: fcf.application.getTheme().getAliases(),
                            filters: fcf.application.getConfiguration().filters,
                            decor:   fcf.application.getTheme().getDecor(),
                            views:   fcf.application.getTheme().getInfo().views ? fcf.application.getTheme().getInfo().views : {},
                          }) + 
                          ");";
        a_request.send(resultContext);
      }

    }

    return fcf.NServer.NControllers.Settings;
  }
});
