fcf.module({
  name: "fcf:NFSQL/Parser.js",
  dependencies: ["fcf:NFSQL/NDetails/SingleParser.js"],
  module: function(SingleParser) {
    var NFSQL = fcf.prepareObject(fcf, "NFSQL");

    NFSQL.Parser = function() {

      this._parser = new SingleParser();

      this.parse = function(a_fsqls, a_args) {
        var result = [];
        var queries = this._split(a_fsqls);
        for(var i = 0; i < queries.length; ++i)
          result.push(this._parser.parse(queries[i], a_args));
        return result;
      }

      this.parseWhere = function(a_fsqls, a_args) {
        return this._parser.parseWhere(a_fsqls, a_args);
      }

      this._split = function(a_fsqls) {
        var result = [];
        var buffer = "";
        var slash = 0;
        var inQuote = false;
        for (var i = 0; i < a_fsqls.length; ++i) {
          var c = a_fsqls.charAt(i);

          if (c === "\\"){
            ++slash;
            buffer += c;
            continue;
          }

          if ((slash % 2) == 0 && c === "\""){
            inQuote = !inQuote;
            slash = 0;
            buffer += c;
            continue;
          }

          if (!inQuote && c === ";"){
            buffer = fcf.trim(buffer);
            if (buffer != "")
              result.push(buffer);
            buffer = "";
            slash = 0;
            continue;
          }

          buffer += c;
          slash = 0;
        }

        buffer = fcf.trim(buffer);
        if (buffer != "")
          result.push(buffer);

        return result;
      }

    }

    return NFSQL.Parser;
  }
});
