fcf.module({
  name: "fcf:NFSQL/Builder.js",
  dependencies: ["fcf:NFSQL/NDetails/SingleBuilder.js"],
  module: function(SingleBuilder) {
    var NFSQL = fcf.prepareObject(fcf, "NFSQL");

    NFSQL.Builder = function() {

      this._builder = new SingleBuilder();

      this.build = function(a_queryObjects) {
        var result = {
          query: "",
          args: []
        };

        a_queryObjects = Array.isArray(a_queryObjects) ? a_queryObjects : [a_queryObjects];
        for(var i = 0; i < a_queryObjects.length; ++i) {
          var resItem = this._builder.build(a_queryObjects[i], result.args.length);
          if (i != 0)
            result.query += "; ";
          result.query += resItem.query;
          fcf.append(result.args, resItem.args);
        }

        return result;
      }

    }

    return NFSQL.Builder;
  }
});
