fcf.module({
  name: "fcfManagement:templates/pages/development/tabs/queries.wrapper.js",
  dependencies: ["fcf:NClient/Wrapper.js"],
  module: function(Wrapper){
    return class WrapperEx extends Wrapper{
      
      constructor(a_initializeOptions){
        super(a_initializeOptions);
      }

      onArgResult(a_value){
        let columns = fcf.array(a_value[0], (a_column)=>{ return { title: a_column, alias: a_column, type: "text"}; })
        this.setArg("columns", columns);
        this.update();
      }

      onArgError(a_value){
        this.update();
      }

      onRemoveArg(a_argIndex){
        let args = this.getArg("arguments");
        args.splice(a_argIndex, 1);
        this.setArg("arguments", args);
        this.update();
      }

      onAppendArgument(){
        let args = this.getArg("arguments");
        if (args.length == 0)
          args.push("");
        args.push("");
        this.setArg("arguments", args);
        this.update();
      }

      onExecute() {
        let self  = this;
        let query = this.getArg("query");
        let args  = this.getArg("arguments");

        fcf.loadObject({path: "/fcfpackages/fcfManagement/fsql", post: {query: query, args: args}})
        .then((a_result)=>{
          self.setArg("error",  undefined);
          self.setArg("result", a_result[0]);
        })
        .catch((a_error)=>{
          self.setArg("error",  a_error);
          self.setArg("result", []);
        })
      }

      onClear() {
        this.setArg("query", "");
        this.setArg("error",  undefined);
        this.setArg("result", []);
        this.setArg("arguments", []);
      }

    };
  }
});
