fcf.module({
  name: "fcf:NFSQL/NFilter/Float.js",
  dependencies: ["fcf:NFSQL/NFilter/BaseSimpleType.js", "fcf:NFSQL/NFilter/Errors.js"],
  module: function(BaseSimpleType, Errors) {
    var NFilter = fcf.prepareObject(fcf, "NFSQL.NFilter");

    NFilter.Float = class Float extends BaseSimpleType {

      constructor(){
        super({type: "float"}) ;
        this.comparisons = {
          "*": ["=", "<", ">", "<>", ">=", "<=", "like"],
        };
      }

      validate(a_description, a_dstErrors) {
        var value = a_description.data;
        var field = a_description.field;
        if (typeof value !== "number")
          value = parseInt(value);

        var from = a_description.projection ? a_description.projection.alias: "unknown";

        if (isNaN(value)){
          a_dstErrors.push(new fcf.Exception("ERROR_NFSQL_INCORRECT_FLOAT_TYPE", {projection: from, field: field.alias, value: value}));
          return;
        }

        if (typeof field.min == "number" && value < field.min)
          a_dstErrors.push(new fcf.Exception("ERROR_NFSQL_INCORRECT_FLOAT_MIN", {projection: from, field: field.alias, value: value, min: field.min}));

        if (typeof field.max == "number" && value > field.max)
          a_dstErrors.push(new fcf.Exception("ERROR_NFSQL_INCORRECT_FLOAT_MAX", {projection: from, field: field.alias, value: value, max: field.max}));

        var maxInt = Math.pow(2, 32)/2;
        var minInt = -maxInt;
        if (value < minInt)
          a_dstErrors.push(new fcf.Exception("ERROR_NFSQL_INCORRECT_FLOAT_MIN", {projection: from, field: field.alias, value: value, min: minInt}));

        if (value > maxInt)
          a_dstErrors.push(new fcf.Exception("ERROR_NFSQL_INCORRECT_FLOAT_MAX", {projection: from, field: field.alias, value: value, max: maxInt}));
      }

      insertFieldHandler(a_handler, a_queryObject, a_originQueryObject, a_container, a_key, a_originContainer, a_originKey){
        var f = a_container[a_key];
        var of = a_originContainer[a_originKey];
        var value = typeof of.value !== "string" || fcf.trim(of.value) != "" ? of.value : null;
        f.value = value;
        this.checkModify(a_handler, a_queryObject, a_originQueryObject, a_container, a_key, a_originContainer, a_originKey);
      }

    }

    return NFilter.Float;
  }
});
