fcf.module({
  name: "fcf:NFSQL/NDetails/AutomateFieldEx.js",
  dependencies: [],
  module: function() {
    var Automate = fcf.prepareObject(fcf, "NFSQL.NDetails.Automate");

    Automate.getOptionsFieldEx = function(a_state) {
      return a_state.details.fieldex;
    }

    Automate.setOptionsFieldEx = function(a_state, a_options) {
      a_state.details.fieldex = a_options;
    }

    Automate.setFieldEx = function(a_state, a_field) {
      a_state.details.fieldex.stack[a_state.details.fieldex.stack.length-1].push(a_field);
    }

    Automate.getFieldEx = function(a_state) {
      var fields = a_state.details.fieldex.stack[a_state.details.fieldex.stack.length-1];
      return fields[fields.length - 1];
    }

    Automate.pushStackFieldEx = function(a_state, a_arr) {
      a_state.details.fieldex.stack.push(a_arr);
    }

    Automate.popStackFieldEx = function(a_state) {
      a_state.details.fieldex.stack.pop();
    }

    Automate.getFiledExPath = function(a_state) {
      let result = a_state.details.fieldex.path;
      for(let i = 1; i < a_state.details.fieldex.stack.length; ++i)
        result += `.args[${a_state.details.fieldex.stack[i].length-1}]`;
      result += ".value";
      return result;
    }




    Automate.StepFieldEx = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.buffer = fcf.trim(this.buffer);
      if (this.buffer == "")
        this.map[""] = { factory: Automate.StepFieldEx_StartSkipSpace, name:  "StepFieldEx_StartSkipSpace", skipFirst: false};
      else
        this.map[""] = { factory: "StepFieldEx_Field_SimpleRead", skipFirst: false, attachBuffer: true};


      this.actionSwitch = function() {
        var fields = this.state.details.stepInfo.fields
                            ? [this.state.details.stepInfo.fields]
                            : [a_state.fields];
        Automate.setOptionsFieldEx(a_state, {
          enableAs:   this.state.details.stepInfo.enableAs,
          enableList: this.state.details.stepInfo.enableList,
          exitMap:    this.state.details.stepInfo.exitMap,
          enableArgs: this.state.details.stepInfo.enableArgs,
          path:       this.state.details.stepInfo.path,
          stack:      fields,
        });
      }
    }

    Automate.StepFieldEx_StartSkipSpace = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map["^{ns}"] = { factory: Automate.StepFieldEx_Field_Start, name:  "StepFieldEx_Field_Start", skipFirst: false};
    }

    Automate.StepFieldEx_Field_Start = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map["^{nm}"] = { factory: Automate.StepFieldEx_Field_SimpleRead, name:  "StepFieldEx_Field_SimpleRead", skipFirst: false};
      this.map["\""] = { factory: Automate.StepFieldEx_Field_DQuoteRead, name:  "StepFieldEx_Field_DQuoteRead", skipFirst: true};
      this.map["*"] = { factory: Automate.StepFieldEx_Field_AllRead, name:  "StepFieldEx_Field_AllRead", skipFirst: true};


      var options = Automate.getOptionsFieldEx(a_state);
      if (options.stack.length > 1 || options.enableArgs)
        this.map["$"] = { factory: Automate.StepFieldEx_Field_StartValue, name:  "StepFieldEx_Field_StartValue", skipFirst: true};
    }

    Automate.StepFieldEx_Field_StartValue = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["{"] = { factory: Automate.StepFieldEx_Field_ReadValue, name:  "StepFieldEx_Field_ReadValue", skipFirst: true};
      this.map["["] = { factory: Automate.StepFieldEx_Field_ReadRes_Part1,   name:  "StepFieldEx_Field_ReadRes", skipFirst: true};
    }


    Automate.StepFieldEx_Field_ReadRes_Part1 = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map["^{n}"] = { factory: "StepFieldEx_Field_ReadRes_Part1Read", skipFirst: false};
      this.map["-"] = { factory: "StepFieldEx_Field_ReadRes_Part1Minus", skipFirst: true};

      this.actionSwitch = function() {
        var arg = {};
        arg.result = undefined;
        arg.record = undefined;
        arg.item   = "";
        Automate.setFieldEx(this.state, arg);
      }
    }

    Automate.StepFieldEx_Field_ReadRes_Part1Minus = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{n}"] = { factory: "StepFieldEx_Field_ReadRes_Part1Read", skipFirst: false};

      this.actionSwitch = function() {
        var field = Automate.getFieldEx(this.state);
        field.minus = true;

      }
    }


    Automate.StepFieldEx_Field_ReadRes_Part1Read = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{n}"] = null;
      this.map[""] = { factory: "StepFieldEx_Field_ReadRes_Part2WaitEnd", skipFirst: false};

      this.actionSwitch = function() {
        var field = Automate.getFieldEx(this.state);
        var number = parseInt(this.buffer);
        if (isNaN(number))
          throw "Incorrect value";
        field.result = number;
        if (field.minus) {
          field.result = -field.result;
          delete field.minus;
        }
      }
    }

    Automate.StepFieldEx_Field_ReadRes_Part2WaitEnd = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map[""] = null;
      this.map["]"] = { factory: "StepFieldEx_Field_ReadRes_Part2WaitStart", skipFirst: true};
    }

    Automate.StepFieldEx_Field_ReadRes_Part2WaitStart = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map["["] = { factory: "StepFieldEx_Field_ReadRes_Part2WaitRead", skipFirst: true};
    }

    Automate.StepFieldEx_Field_ReadRes_Part2WaitRead = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map["^{n}"] = { factory: "StepFieldEx_Field_ReadRes_Part2Read", skipFirst: false};
    }

    Automate.StepFieldEx_Field_ReadRes_Part2Read = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{n}"] = null;
      this.map[""] = { factory: "StepFieldEx_Field_ReadRes_Part2Close", skipFirst: false};
      this.actionSwitch = function() {
        var field = Automate.getFieldEx(this.state);
        var number = parseInt(this.buffer);
        if (isNaN(number))
          throw "Incorrect value";
        field.record = number;
      }
    }

    Automate.StepFieldEx_Field_ReadRes_Part2Close = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map[""] = null;
      this.map["]"] = { factory: "StepFieldEx_Field_ReadRes_Part3Wait", skipFirst: true};
    }


    Automate.StepFieldEx_Field_ReadRes_Part3Wait = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map["["] = { factory: "StepFieldEx_Field_ReadRes_Part3Start", skipFirst: true};
    }

    Automate.StepFieldEx_Field_ReadRes_Part3Start = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map["^{nm}"] = { factory: "StepFieldEx_Field_ReadRes_Part3Read", skipFirst: false};
      this.map["\""] = { factory: "StepFieldEx_Field_ReadRes_Part3ReadDQuotes", skipFirst: true};
    }

    Automate.StepFieldEx_Field_ReadRes_Part3Read = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{nm}"]  = null;
      this.map["^{nnm}"] = { factory: "StepFieldEx_Field_ReadRes_Part3WaitClose", skipFirst: false};

      this.actionSwitch = function() {
        var field = Automate.getFieldEx(this.state);
        field.item = this.buffer;
      }
    }

    Automate.StepFieldEx_Field_ReadRes_Part3ReadDQuotes = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map[""]  = null;
      this.map["\""] = { factory: "StepFieldEx_Field_ReadRes_Part3WaitClose", skipFirst: true};

      this.actionSwitch = function() {
        var field = Automate.getFieldEx(this.state);

        field.item = this.buffer;
      }
    }

    Automate.StepFieldEx_Field_ReadRes_Part3WaitClose = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.map[""]  = null;
      this.map["]"] = { factory: "StepFieldEx_Field_ReadRes_Part3Close", skipFirst: true};
    }

    Automate.StepFieldEx_Field_ReadRes_Part3Close = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      var options = Automate.getOptionsFieldEx(a_state);
      if (options.enableList || options.stack.length > 1)
        this.map[","] = { factory: Automate.StepFieldEx_Field_Start, name:  "StepFieldEx_Field_Start", skipFirst: true};
      if (options.stack.length > 1) {
        this.map[")"] = { factory: Automate.StepFieldEx_Field_FunctionClose, name:  "StepFieldEx_Field_FunctionClose", skipFirst: true};
      }
      if (!options.enableList){
        fcf.append(this.map, options.exitMap);
      }
    }



    Automate.StepFieldEx_Field_ReadValue = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{n}"] = null;
      this.map["}"] = { factory: "StepFieldEx_Field_ReadValueClose", skipFirst: true};

      this.actionSwitch = function() {
        var number = parseInt(this.buffer);
        if (isNaN(number))
          throw "Incorrect value";
        var value = this.state.details.args[number-1];
        Automate.setFieldEx(this.state, { value: value });
        this.state.args[Automate.getFiledExPath(this.state)] = number;
      }
    }

    Automate.StepFieldEx_Field_ReadValueClose = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      var options = Automate.getOptionsFieldEx(a_state);
      if (options.enableList || options.stack.length > 1)
        this.map[","] = { factory: Automate.StepFieldEx_Field_Start, name:  "StepFieldEx_Field_Start", skipFirst: true};
      if (options.stack.length > 1) {
        this.map[")"] = { factory: Automate.StepFieldEx_Field_FunctionClose, name:  "StepFieldEx_Field_FunctionClose", skipFirst: true};
      }
      if (!options.enableList){
        fcf.append(this.map, options.exitMap);
      }
    }

    Automate.StepFieldEx_Field_DQuoteRead = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map[""] = null;
      this.map["\""] = { factory: Automate.StepFieldEx_Field_SimpleRead_ReadNext, name:  "StepFieldEx_Field_SimpleRead_ReadNext", skipFirst: true};

      this.actionSwitch = function() {
        Automate.setFieldEx(this.state, { field: this.buffer });
      }
    }

    Automate.StepFieldEx_Field_SimpleRead = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{nm}"] = null;
      this.map[""] = { factory: Automate.StepFieldEx_Field_SimpleRead_ReadNext, name:  "StepFieldEx_Field_SimpleRead_ReadNext", skipFirst: false};

      this.actionSwitch = function() {
        Automate.setFieldEx(this.state, { field: this.buffer });
      }
    }

    Automate.StepFieldEx_Field_AllRead = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      var options = Automate.getOptionsFieldEx(a_state);
      this.map["^{nm}"] = { factory: Automate.StepFieldEx_Field_SimpleRead_WaitCommand, name:  "StepFieldEx_Field_SimpleRead_WaitCommand", skipFirst: false};
      if (options.enableList || options.stack.length > 1)
        this.map[","] = { factory: Automate.StepFieldEx_Field_Start, name:  "StepFieldEx_Field_Start", skipFirst: true};

      this.actionSwitch = function() {
        Automate.setFieldEx(this.state, { field: "*" });
      }
    }

    Automate.StepFieldEx_Field_AllReadSecondPart = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      var options = Automate.getOptionsFieldEx(a_state);
      this.map["^{nm}"] = { factory: Automate.StepFieldEx_Field_SimpleRead_WaitCommand, name:  "StepFieldEx_Field_SimpleRead_WaitCommand", skipFirst: false};
      if (options.enableList || options.stack.length > 1)
        this.map[","] = { factory: Automate.StepFieldEx_Field_Start, name:  "StepFieldEx_Field_Start", skipFirst: true};

      this.actionSwitch = function() {
        var field = Automate.getFieldEx(this.state);
        field.from  = field.field;
        field.field = "*";
      }
    }

    Automate.StepFieldEx_Field_SimpleRead_ReadNext = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map["."]     = { factory: "StepFieldEx_Field_SecondPart_SkipSpaces", name:  "StepFieldEx_Field_SecondPart_SkipSpaces", skipFirst: true};
      this.map[":"]     = { factory: "StepFieldEx_Field_ReadMode", skipFirst: true};
      this.map["-"]     = { factory: "StepFieldEx_Field_ReadExField", skipFirst: true};


      this.map["("]     = { factory: Automate.StepFieldEx_Field_FunctionRead, name:  "StepFieldEx_Field_FunctionRead", skipFirst: true};

      var options = Automate.getOptionsFieldEx(a_state);
      if (options.enableList || options.stack.length > 1)
        this.map[","] = { factory: Automate.StepFieldEx_Field_Start, name:  "StepFieldEx_Field_Start", skipFirst: true};
      if (options.stack.length > 1)
        this.map[")"] = { factory: Automate.StepFieldEx_Field_FunctionClose, name:  "StepFieldEx_Field_FunctionClose", skipFirst: true};

      if (!options.enableList){
        fcf.append(this.map, options.exitMap);
      } else {
        this.map[""] = { factory: Automate.StepFieldEx_Field_SimpleRead_WaitCommand, name:  "StepFieldEx_Field_SimpleRead_WaitCommand", skipFirst: false};
      }
    }

    Automate.StepFieldEx_Field_FunctionRead = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map[""] = { factory: Automate.StepFieldEx_StartSkipSpace, name:  "StepFieldEx_StartSkipSpace", skipFirst: false};
      this.map[")"] = { factory: Automate.StepFieldEx_Field_FunctionClose, name:  "StepFieldEx_Field_FunctionClose", skipFirst: true};
      this.actionSwitch = function() {
        var field = Automate.getFieldEx(this.state);
        field.function = field.field;
        field.args = [];
        delete field.field;
        Automate.pushStackFieldEx(this.state, field.args);
      }
    }

    Automate.StepFieldEx_Field_FunctionClose = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;

      var options = Automate.getOptionsFieldEx(a_state);
      if (options.enableList || options.stack.length > 2)
        this.map[","] = { factory: Automate.StepFieldEx_Field_Start, name:  "StepFieldEx_Field_Start", skipFirst: true};
      if (!options.enableList){
        fcf.append(this.map, options.exitMap);
      } else {
        this.map["^{nm}"] = { factory: Automate.StepFieldEx_Field_SimpleRead_WaitCommand, name:  "StepFieldEx_Field_SimpleRead_WaitCommand", skipFirst: false};
      }
      this.actionSwitch = function() {
        Automate.popStackFieldEx(this.state);
      }
    }

    Automate.StepFieldEx_Field_ReadExField = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.map[">"] = { factory: "StepFieldEx_Field_ReadExField_WaitData", skipFirst: true};
    }

    Automate.StepFieldEx_Field_ReadExField_WaitData = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.map["^{s}"] = null;
      this.map["^{nm}"] = { factory: "StepFieldEx_Field_ReadExField_ReadData", skipFirst: false};
      this.map["\""] = { factory: "StepFieldEx_Field_ReadExField_ReadDataDQuote", skipFirst: true};
    }


    Automate.StepFieldEx_Field_ReadExField_ReadData = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.map["^{nm}"] = null;
      this.map["^{nnm}"] = { factory: "StepFieldEx_Field_ReadExField_End", skipFirst: false};

      this.actionSwitch = function() {
        var field = Automate.getFieldEx(this.state);
        if (!field.path)
          field.path = [];
        field.path.push(this.buffer);
      }
    }

    Automate.StepFieldEx_Field_ReadExField_ReadDataDQuote = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.map[""] = null;
      this.map["\""] = { factory: "StepFieldEx_Field_ReadExField_End", skipFirst: true};

      this.actionSwitch = function() {
        var field = Automate.getFieldEx(this.state);
        if (!field.path)
          field.path = [];
        field.path.push(this.buffer);
      }
    }

    Automate.StepFieldEx_Field_ReadExField_End = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map["-"] = { factory: "StepFieldEx_Field_ReadExField", skipFirst: true};

      var options = Automate.getOptionsFieldEx(a_state);
      if (options.enableList || options.stack.length > 1)
        this.map[","] = { factory: Automate.StepFieldEx_Field_Start, name:  "StepFieldEx_Field_Start", skipFirst: true};
      if (options.stack.length > 1)
        this.map[")"] = { factory: Automate.StepFieldEx_Field_FunctionClose, name:  "StepFieldEx_Field_FunctionClose", skipFirst: true};

      if (!options.enableList){
        fcf.append(this.map, options.exitMap);
      } else {
        this.map[""] = { factory: Automate.StepFieldEx_Field_SimpleRead_WaitCommand, name:  "StepFieldEx_Field_SimpleRead_WaitCommand", skipFirst: false};
      }
    }



    Automate.StepFieldEx_Field_ReadMode = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map["^{nm}"] = { factory: "StepFieldEx_Field_ReadMode_SetData", skipFirst: false};
      this.map["\""]    = { factory: "StepFieldEx_Field_ReadMode_SetDataQuote", skipFirst: true};
    }

    Automate.StepFieldEx_Field_ReadMode_SetData = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{nm}"] = null;
      this.map["^{nnm}"] = { factory: "StepFieldEx_Field_ReadMode_End", skipFirst: false};

      this.actionSwitch = function() {
        var field = Automate.getFieldEx(this.state);
        field.mode = this.buffer;
      }
    }

    Automate.StepFieldEx_Field_ReadMode_SetDataQuote = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map[""] = null;
      this.map["\""] = { factory: "StepFieldEx_Field_ReadMode_End", skipFirst: true};

      this.actionSwitch = function() {
        var field = Automate.getFieldEx(this.state);
        field.mode = this.buffer;
      }
    }

    Automate.StepFieldEx_Field_ReadMode_End = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;

      this.map[":"] = { factory: "StepFieldEx_Field_ReadSubField", skipFirst: true};
      this.map["-"] = { factory: "StepFieldEx_Field_ReadExField", skipFirst: true};

      var options = Automate.getOptionsFieldEx(a_state);
      if (options.enableList || options.stack.length > 1)
        this.map[","] = { factory: Automate.StepFieldEx_Field_Start, name:  "StepFieldEx_Field_Start", skipFirst: true};
      if (options.stack.length > 1)
        this.map[")"] = { factory: Automate.StepFieldEx_Field_FunctionClose, name:  "StepFieldEx_Field_FunctionClose", skipFirst: true};

      if (!options.enableList){
        fcf.append(this.map, options.exitMap);
      } else {
        this.map[""] = { factory: Automate.StepFieldEx_Field_SimpleRead_WaitCommand, name:  "StepFieldEx_Field_SimpleRead_WaitCommand", skipFirst: false};
      }
    }

    Automate.StepFieldEx_Field_ReadSubField = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map["^{nm}"] = { factory: "StepFieldEx_Field_ReadSubField_Data", skipFirst: false};
      this.map["\""] = { factory: "StepFieldEx_Field_ReadSubField_QuoteData", skipFirst: true};
    }


    Automate.StepFieldEx_Field_ReadSubField_Data = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{nm}"] = null;
      this.map["^{nnm}"] = { factory: "StepFieldEx_Field_ReadSubField_End", skipFirst: false};

      this.actionSwitch = function() {
        var field = Automate.getFieldEx(this.state);
        field.result = this.buffer;
      }
    }

    Automate.StepFieldEx_Field_ReadSubField_QuoteData = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map[""] = null;
      this.map["\""] = { factory: "StepFieldEx_Field_ReadSubField_End", skipFirst: true};

      this.actionSwitch = function() {
        var field = Automate.getFieldEx(this.state);
        field.result = this.buffer;
      }
    }

    Automate.StepFieldEx_Field_ReadSubField_End = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;

      var options = Automate.getOptionsFieldEx(a_state);
      if (options.enableList || options.stack.length > 1)
        this.map[","] = { factory: Automate.StepFieldEx_Field_Start, name:  "StepFieldEx_Field_Start", skipFirst: true};
      if (options.stack.length > 1)
        this.map[")"] = { factory: Automate.StepFieldEx_Field_FunctionClose, name:  "StepFieldEx_Field_FunctionClose", skipFirst: true};

      if (!options.enableList){
        fcf.append(this.map, options.exitMap);
      } else {
        this.map[""] = { factory: Automate.StepFieldEx_Field_SimpleRead_WaitCommand, name:  "StepFieldEx_Field_SimpleRead_WaitCommand", skipFirst: false};
      }
    }



    Automate.StepFieldEx_Field_SecondPart_SkipSpaces = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map["^{nm}"] = { factory: Automate.StepFieldEx_Field_SecondPart_SimpleRead, name:  "StepFieldEx_Field_SecondPart_SimpleRead", skipFirst: false};
      this.map["\""] = { factory: Automate.StepFieldEx_Field_SecondPart_DQuotesRead, name:  "StepFieldEx_Field_SecondPart_DQuotesRead", skipFirst: true};
      this.map["*"] = { factory: Automate.StepFieldEx_Field_AllReadSecondPart, name:  "StepFieldEx_Field_AllReadSecondPart", skipFirst: true};
    }

    Automate.StepFieldEx_Field_SecondPart_DQuotesRead = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map[""] = null;
      this.map["\""] = { factory: Automate.StepFieldEx_Field_SimpleRead_ReadNext, name:  "StepFieldEx_Field_SimpleRead_ReadNext", skipFirst: true};

      this.actionSwitch = function() {
        var field = Automate.getFieldEx(this.state);
        field.from = field.field;
        field.field = this.buffer;
      }
    }

    Automate.StepFieldEx_Field_SecondPart_SimpleRead = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{nm}"] = null;
      this.map[""] = { factory: Automate.StepFieldEx_Field_SimpleRead_ReadNext, name:  "StepFieldEx_Field_SimpleRead_ReadNext", skipFirst: false};

      this.actionSwitch = function() {
        var field = Automate.getFieldEx(a_state);
        field.from = field.field;
        field.field = this.buffer;
      }
    }

    Automate.StepFieldEx_Field_SimpleRead_WaitCommand = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{nm}"] = null;
      this.map["^{nnm}"] = { map: {}};

      var options = Automate.getOptionsFieldEx(a_state);
      if (options.enableAs)
        this.map["^{nnm}"].map["as"] = { factory: Automate.StepFieldEx_Field_AsSkipSpaces, name:  "StepFieldEx_Field_AsSkipSpaces", skipFirst: false};

      if (!fcf.empty(options.exitMap))
        fcf.append(this.map["^{nnm}"].map, options.exitMap);
    }

    Automate.StepFieldEx_Field_SimpleRead_WaitFrom = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "^{s}";

      var options = Automate.getOptionsFieldEx(a_state);
      if (!fcf.empty(options.exitMap))
        fcf.append(this.map, options.exitMap);
    }

    Automate.StepFieldEx_Field_AsSkipSpaces = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map[""] = { factory: Automate.StepFieldEx_Field_AsSimpleRead, name:  "StepFieldEx_Field_AsSimpleRead", skipFirst: false};
      this.map["\""] = { factory: Automate.StepFieldEx_Field_AsDQuotesRead, name:  "StepFieldEx_Field_AsDQuotesRead", skipFirst: true};
    }

    Automate.StepFieldEx_Field_AsDQuotesRead = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map[""] = null;
      this.map["\""] = { factory: Automate.StepFieldEx_Field_AsNext, name:  "StepFieldEx_Field_AsNext", skipFirst: true};
      this.actionSwitch = function() {
        var field = Automate.getFieldEx(this.state);
        field.as      = this.buffer;
      }
    }

    Automate.StepFieldEx_Field_AsSimpleRead = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{nm}"] = null;
      this.map[""] = { factory: Automate.StepFieldEx_Field_AsNext, name:  "StepFieldEx_Field_AsNext", skipFirst: false};
      this.actionSwitch = function() {
        var field = Automate.getFieldEx(this.state);
        field.as  = this.buffer;
      }
    }

    Automate.StepFieldEx_Field_AsNext = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map[""] = { factory: Automate.StepFieldEx_Field_SimpleRead_WaitFrom, name:  "StepFieldEx_Field_SimpleRead_WaitFrom", skipFirst: false};

      var options = Automate.getOptionsFieldEx(a_state);
      if (options.enableList || options.stack.length > 1)
        this.map[","] = { factory: Automate.StepFieldEx_Field_Start, name:  "StepFieldEx_Field_Start", skipFirst: true};
      if (options.stack.length > 1)
        this.map[")"] = { factory: Automate.StepFieldEx_Field_FunctionClose, name:  "StepFieldEx_Field_FunctionClose", skipFirst: true};
    }


    return Automate;
  }
});
