fcf.module({
  name: "fcf:tests/NFSQL/Helpers/Helper.js",
  dependencies: ["fcf:NFSQL/Storage.js", "fcf:NFSQL/Projections.js"],
  module: function(Storage, Projections) {
    var Helpers = fcf.prepareObject(fcf, "tests/NFSQL/Helpers");

    var projections = new Projections();

    Helpers.initialize = function(){
      return projections.loadFromFiles([
        "fcf:tests/NFSQL/projections/fcftest_single_types1.projection",
        "fcf:tests/NFSQL/projections/fcftest_single_types2.projection",
        "fcf:tests/NFSQL/projections/fcftest_single_types_update1.projection",
        "fcf:tests/NFSQL/projections/fcftest_single_types_update2.projection",
        "fcf:tests/NFSQL/projections/fcftest_single_types_insert1.projection",
        "fcf:tests/NFSQL/projections/fcftest_single_types_joininsert.projection",
        "fcf:tests/NFSQL/projections/fcftest_single_types_joininsert_slave.projection",
        "fcf:tests/NFSQL/projections/fcftest_single_types_joininsert_master.projection",
        "fcf:tests/NFSQL/projections/fcftest_file_table.projection",
        "fcf:tests/NFSQL/projections/fcftest_file_table_join.projection",
        "fcf:tests/NFSQL/projections/fcftest_file_table_refjoin.projection",
        "fcf:tests/NFSQL/projections/fcftest_externref_test_entity.projection",
        "fcf:tests/NFSQL/projections/fcftest_externref_test_ref.projection",
        "fcf:tests/NFSQL/projections/fcftest_externref_test.projection",
        "fcf:tests/NFSQL/projections/fcftest_externref_test_join.projection",
        "fcf:tests/NFSQL/projections/fcftest_externref_test_ref_dynamic.projection",
        "fcf:tests/NFSQL/projections/fcftest_externref_test_dynamic.projection",
        "fcf:tests/NFSQL/projections/fcftest_externref_test_dynamic_join.projection",
        "fcf:tests/NFSQL/projections/fcftest_singleref_test_entity.projection",
        "fcf:tests/NFSQL/projections/fcftest_singleref_test.projection",
        "fcf:tests/NFSQL/projections/fcftest_singleref_test_dynamic.projection",
        "fcf:tests/NFSQL/projections/fcftest_singleref_test_join.projection",
        "fcf:tests/NFSQL/projections/fcftest_singleref_test_dynamic_join.projection",
        "fcf:tests/NFSQL/projections/fcftest_backref_test.projection",
        "fcf:tests/NFSQL/projections/fcftest_backref_test_ref.projection",
        "fcf:tests/NFSQL/projections/fcftest_backref_test_dynamic.projection",
        "fcf:tests/NFSQL/projections/fcftest_backref_test_ref_dynamic.projection",
      ]);
    }


    Helpers.getStorage = function(a_tester){
      if (a_tester.storage)
        return a_tester.storage;
      a_tester.storage = new Storage({
        connections: { default: { type: "mysql", host: "localhost", db: "fcftest", user: "fcftest", pass: "fcftest", } },
        projections: projections,
      });

      return a_tester.storage;
    }

    Helpers.query = function(a_tester, a_options, a_cb) {
      let actions = a_options.actions ? a_options.actions : a_tester.actions;
      return actions.then(function(a_res, a_act) {
        Helpers.getStorage(a_tester).query(a_options, function(a_error, a_records) {
          if (a_error) {
            fcf.log.err("TEST", a_error);
            a_act.error(a_error);
            return;
          }

          try {
            if (a_cb)
              a_cb(a_records);
          } catch (error){
            fcf.log.err("TEST", error);
            a_act.error(error);
            return;
          }

          a_act.complete();
        });
      });
    }

    return Helpers;
  }
});
