<?php // $Id: diet.php 83 2010-12-11 01:22:32Z mashiki $
	$src = "extwiki/extwiki-debug.js";
	$dest= "extwiki/extwiki.js";
	minimize($src, $dest);

	function minimize($src, $dest) {
		$fsrc = fopen($src,'r');
		$fdest = fopen($dest,'w');
		fwrite($fdest, '//$'.'Id'.':$');

		while (!feof($fsrc)) {
			$line = fgets($fsrc, 1024);

			// 行コメントの削除
			if (($wk = my_split('//', $line))) {
				$line = $wk[0];
			}

			// インデント及び行末の空白の削除
			$line = trim($line);

			// 空行の削除
			if ($line==='') continue;

			// コメントの削除
			// コーディングルールで下記を守ること
			// ・ドキュメント以外の目的で 「/* コメント */」のようなコメントは使用しない
			// ・コメント中の行は必ず「*」から始める
			// ・コメント以外の行は 「*」から始めない
			if (preg_match('/^\/?\*/', $line)) continue;

			// 「:」 の前後の空白の削除
			$line = remove_side_space(':', $line);

			// 「,」 の前後の空白の削除
			$line = remove_side_space(',', $line);

			// 「;」 の前後の空白の削除
			$line = remove_side_space(';', $line);

			// 「(」「)」 の前後の空白の削除
			$line = remove_side_space('(', $line);
			$line = remove_side_space(')', $line);

			// 「{」「}」 の前後の空白の削除
			$line = remove_side_space('{', $line);
			$line = remove_side_space('}', $line);

			// 「[」「]」 の前後の空白の削除
			$line = remove_side_space('[', $line);
			$line = remove_side_space(']', $line);

			// 「=」 の前後の空白の削除
			$line = remove_side_space('=', $line);

			// 「&&」 の前後の空白の削除
			$line = remove_side_space('&&', $line);

			// 「||」 の前後の空白の削除
			$line = remove_side_space('||', $line);

			// 「)」「]」「}」「,」「+」「|」「&」で始まる行を前行に詰める
			$lf = strpos(')]},+|&', $line[0])===FALSE?"\n":'';
			
			fwrite($fdest, "$lf$line");
		}

		fclose($fsrc);
		fclose($fdest);
	}

	// 文字列中でないことを保証し、２つに分ける
	function my_split($sp, $line) {
		$res = explode($sp, $line, 2);
		if (count($res)==2) {
			if (
				(strpos($res[0],'"')===FALSE || strpos($res[1],'"')===FALSE) &&
				(strpos($res[0],"'")===FALSE || strpos($res[1],"'")===FALSE) &&
				(strpos($res[0],"/")===FALSE || strpos($res[1],"/")===FALSE)
			) {
				return $res;
			}
		}
		return FALSE;
	}

	// 特定文字の左右のタブとブランクをとる
	function remove_side_space($ptn, $line) {
		while (($wk = my_split(" $ptn", $line))) {
			$line = rtrim($wk[0]).$ptn.$wk[1];
		}
		while (($wk = my_split("\t$ptn", $line))) {
			$line = rtrim($wk[0]).$ptn.$wk[1];
		}
		while (($wk = my_split("$ptn ", $line))) {
			$line = $wk[0].$ptn.ltrim($wk[1]);
		}
		while (($wk = my_split("$ptn\t", $line))) {
			$line = $wk[0].$ptn.ltrim($wk[1]);
		}
		return $line;
	}

?>