<?php
/**
@brief Doxygen API 
*/

require_once "../../mainfile.php";
require_once XOOPS_ROOT_PATH."/header.php";
require_once XOOPS_ROOT_PATH."/modules/exFrame/frameloader.php";
require_once "./class/global.php";

$info = Xoxygen::getRequestInfomation();

$handler = Xoxygen::getHandler("project");
$project =& $handler->get($info->id_);

if(!is_object($project) && !isset($_POST['word'])) {
	redirect_header ( "index.php", 1, _MD_XOXYGEN_MESSAGE_INVALID_ACCESS );
	exit;
}

// Ϥʬ
$tmp = explode(" ",$_POST['word']);
$words = array();
foreach($tmp as $str) {
	if($str)
		$words[] = $str;
}

$results=array();
//------------------------------------------------------
// hierarchy.html 긡
//------------------------------------------------------
$filename = $project->getPath()."hierarchy.html";
$fp = fopen($filename,"rt");
if($fp) {
   	while ( $str = fgets($fp) ) {
   		if(preg_match('!<li><a class="el" href="(\S+)">(\w+)</a>!',$str,$match)) {
   			$page = $match[1];
   			$class = $match[2];
   			foreach($words as $word) {
	   			if(preg_match("/".$word."/i",$class)) {
	   				$results[] = array (
	   					'page'=>$page,
	   					'subject'=>$class );
	   				break;
	   			}
   			}
   		}
   	}
   	fclose($fp);
}

//------------------------------------------------------
// functions.html 긡
//------------------------------------------------------
$filename = $project->getPath()."functions.html";
$fp = fopen($filename,"rt");
if($fp) {
   	while ( $str = fgets($fp) ) {
   		if(preg_match('!<a class="el" href="(\S+)">(\w+)</a><li>(\w+)!',$str,$match)) {
   			$page = $match[1];
   			$class = $match[2];
   			$function = $match[3];
   			foreach($words as $word) {
	   			if(preg_match("/".$word."/i",$function)) {
	   				$results[] = array (
	   					'page'=>$page,
	   					'subject'=>$class."::".$function );
	   				break;
	   			}
   			}
   		}
   	}
   	fclose($fp);
}

$xoopsOption['template_main'] = 'xoxygen_results.html';
$xoopsTpl->assign("project",$project->getStructure());
$xoopsTpl->assign("results",$results);
require_once XOOPS_ROOT_PATH."/footer.php";

?>
