<?php
/**
@brief Сڥ饹᥽åɤƤե
@author minahito
@version $Id$
*/

require_once dirname(__FILE__)."/../framechecker.php";
__exframe_version__('0.8.9');

if(!defined("XOXYGEN_DEFALUT_PAGE")) {
	define("XOXYGEN_DEFAULT_PAGE","index.html");
}

/**
@brief ƤɽꥯȤǼ륹ȥ饯
*/
class XoxygenRequestInfomation {
	var $id_;		///< ץ ID
	var $page_;	///< ڡʥե̾

	function XoxygenRequestInfomation($id=0,$page=null) {
		$this->setId($id);
		$this->setPage ( $page );
	}

	/**
	@brief ץ ID 򥻥åȤޤ
	@param $id int
	*/
	function setId($id) {
		$this->id_ = intval($id);
	}
	
	/**
	@brief ڡ򥻥åȤޤ
	@param $id int
	*/
	function setPage($page=null) {
		$this->page_ = $page ? $page : XOXYGEN_DEFAULT_PAGE;
		$this->validate();
	}

	/**
	@brief ץ ID ֤ޤ
	@return int
	*/
	function getId() {
		return $this->page_;
	}

	/**
	@brief ڡ֤ޤ
	@return string
	*/
	function getPage() {
		return $this->page_;
	}

	/**
	@brief ڡγĥҤ֤ޤΤȤɬʸ֤ޤ
	@return string ĥҤʤȤ null ֤ޤ
	*/
	function getExtension() {
		if ( preg_match("/\.(\w+)$/",$this->page_,$match) )
			return strtolower($match[1]);
		else
			return null;
	}
	
	
	/**
	@brief  page ̤åԤޤ
	*/
	function validate() {
		$this->page_ = str_replace("..","",$this->page_);
	}
}

class Xoxygen {
	function &getHandler($name) {
		global $xoopsModule;
		static $__cache__;
		global $xoopsDB;

		$name=strtolower(trim($name));
		if(!isset($__cache__[$name])) {
			$class = 'Xoxygen'.ucfirst($name).'Object';

			if(!class_exists($class)) { // ɤ߹
				$filename = XOOPS_ROOT_PATH."/modules/".$xoopsModule->dirname()."/class/".$name.".php";
				if(file_exists($filename)) {
					require_once($filename);
				}
			}

			$handler_class = $class."Handler";
			if(class_exists($handler_class)) {
				$__cache__[$name] = new $handler_class($xoopsDB);
			}
			else { // ɤ߹
				$__cache__[$name] = new exXoopsObjectHandler($xoopsDB,$class);
			}
			return $__cache__[$name];
		}
		else {
			return $__cache__[$name];
		}
	}
	
	/**
	@brief ⥸塼륳ե path_info ǻꤵ줿ʸ $_SERVER Ϥơĥѥޤ
	@return string
	*/
	function getPathInfo() {
		global $xoopsModuleConfig;
		return $_SERVER[$xoopsModuleConfig['path_info']];
	}

	/**
	@brief ĥѥϤ XoxygenRequestInfomation Υ󥹥󥹤֤ޤ
	@return XoxygenRequestInfomation
	*/
	function getRequestInfomation() {
		$pathinfo = Xoxygen::getPathInfo();
		$ret = new XoxygenRequestInfomation();

		$tmp = explode ( "/", $pathinfo );
		if(isset($tmp[1]) && is_numeric($tmp[1]))
			$ret->setId($tmp[1]);

		if(isset($tmp[2]))
			$ret->setPage($tmp[2]);

		return $ret;
	}
}

?>