package com.yuji.em.task;

import android.content.Context;
import android.widget.Toast;

import com.evernote.edam.type.Note;
import com.yuji.em.data.NoteDao;
import com.yuji.em.utility.AsyncTaskIF;
import com.yuji.em.utility.EvernoteUtil;
import com.yuji.em.utility.EvernoteUtil.Error;

public class UpdateNoteTask implements AsyncTaskIF {
	private Context context = null;
	private String guid;
	private String noteName;
	private String title;
	private String text;

	private EvernoteUtil util = EvernoteUtil.getInstance();
	private EvernoteUtil.Error errorCode = null;
	
	public UpdateNoteTask(Context context, String guid, String noteName,
			String title, String text) {
		this.context = context;
		this.guid = guid;
		this.noteName = noteName;
		this.title = title;
		this.text = text;
	}

	@Override
	public void doExecute() {
		synchronized (context) {
			Note note = util.updateNoteContext(guid, title, text);
			if (note != null) {
				NoteDao dao = NoteDao.getInstance();
				com.yuji.em.data.Note n = new com.yuji.em.data.Note(
						note.getGuid(), note.getTitle());
				dao.update(context, n);
			} else {
				errorCode = util.getErrorCode();
			}
		}
	}

	@Override
	public void cancel() {

	}

	@Override
	public void done(boolean isCancel) {
		if (errorCode != null && !errorCode.equals(Error.NONE)){
			Toast.makeText(context, util.getErrorMessage(context, errorCode),
					Toast.LENGTH_LONG).show();			
		}
	}

	@Override
	public int getStatus() {
		if (errorCode != null && !errorCode.equals(Error.NONE)){
			return -1;
		}
		return 0;
	}
}
