package com.yuji.em;

import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.yuji.em.common.CommonUtil;
import com.yuji.em.data.NoteDao;
import com.yuji.em.utility.BaseActivity;
import com.yuji.em.utility.PasswordUtil;

public class SettingActivity extends BaseActivity {
	private LinearLayout messageLayout = null;
	private TextView messageView = null;
	private Button userButton = null;
	private Button noteButton = null;
	private Button headerButton = null;
	private Button closeButton = null;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.setting);

		messageLayout = (LinearLayout) this.findViewById(R.id.settingLayout);
		messageView = (TextView) this.findViewById(R.id.settingMessage);
		userButton = (Button) this.findViewById(R.id.settingUserButton);
		noteButton = (Button) this.findViewById(R.id.settingNoteButton);
		headerButton = (Button) this.findViewById(R.id.settingHeaderButton);
		closeButton = (Button) this.findViewById(R.id.settingCloseButton);

		userButton.setOnClickListener(new OnClickListener() {
			public void onClick(View view) {
				userButtonOnClick();
			}
		});
		noteButton.setOnClickListener(new OnClickListener() {
			public void onClick(View view) {
				noteButtonOnClick();
			}
		});
		headerButton.setOnClickListener(new OnClickListener() {
			public void onClick(View view) {
				headerButtonOnClick();
			}
		});
		closeButton.setOnClickListener(new OnClickListener() {
			public void onClick(View view) {
				closeButtonOnClick();
			}
		});

		setStatus();
	}

	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		if(keyCode != KeyEvent.KEYCODE_BACK){
			return super.onKeyDown(keyCode, event);
		}
		else{
			closeButtonOnClick();
			return false;
		}
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		setStatus();
	}

	private void userButtonOnClick() {
		Intent intent = new Intent(this, (Class<?>) UserPasswordActivity.class);
		startActivityForResult(intent, 0);
	}

	private void noteButtonOnClick() {
		NoteListActivity.init();
		SelectNoteListActivity.init(this);

		Intent intent = new Intent(this,
				(Class<?>) SelectNoteListActivity.class);
		startActivityForResult(intent, 0);
	}

	private void headerButtonOnClick() {
		Intent intent = new Intent(this, (Class<?>) HeaderActivity.class);
		startActivityForResult(intent, 0);
	}

	private void closeButtonOnClick() {
		Intent intent = new Intent();
		setResult(RESULT_OK, intent);
		finish();

		EverMemoActivity.init(false);
	}

	private void setStatus() {
		String passwd = PasswordUtil.getPassword(this);

		if (CommonUtil.isNull(passwd)) {
			messageLayout.setVisibility(View.VISIBLE);
			messageView.setText(getString(R.string.settingConfirmUserMsg));
			noteButton.setEnabled(false);
			headerButton.setEnabled(false);
			return;
		}

		NoteDao dao = NoteDao.getInstance();
		if (dao.isEmpty(this)) {
			messageLayout.setVisibility(View.VISIBLE);
			messageView.setText(getString(R.string.settingConfirmNoteMsg));
			noteButton.setEnabled(true);
			headerButton.setEnabled(false);
			return;
		}
		messageLayout.setVisibility(View.GONE);
		noteButton.setEnabled(true);
		headerButton.setEnabled(true);
	}
}
