<?php
// vim: foldmethod=marker
/**
 *	Ethna.php
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Ethna
 *	@version	$Id: Ethna.php,v 1.25 2005/12/01 06:04:39 fujimoto Exp $
 */

/** Ethna¸饤֥: PEAR, PEAR_Error */
include_once('PEAR.php');

/** Ethna¸饤֥: PEAR::DB */
include_once('DB.php');

/** Ethna¸饤֥: Smarty */
include_once('Smarty/Smarty.class.php');

if (!defined('PATH_SEPARATOR')) {
	if (OS_WINDOWS) {
		/** include_pathѥ졼(Windows) */
		define('PATH_SEPARATOR', ';');
	} else {
		/** include_pathѥ졼(Unix) */
		define('PATH_SEPARATOR', ':');
	}
}
if (!defined('DIRECTORY_SEPARATOR')) {
	if (OS_WINDOWS) {
		/** ǥ쥯ȥꥻѥ졼(Windows) */
		define('DIRECTORY_SEPARATOR', '\\');
	} else {
		/** ǥ쥯ȥꥻѥ졼(Unix) */
		define('DIRECTORY_SEPARATOR', '/');
	}
}

/** С */
define('ETHNA_VERSION', '0.2.0-dev');

/** Ethna١ǥ쥯ȥ */
define('ETHNA_BASE', dirname(__FILE__));

include_once(ETHNA_BASE . '/class/Ethna_ActionClass.php');
include_once(ETHNA_BASE . '/class/Ethna_ActionError.php');
include_once(ETHNA_BASE . '/class/Ethna_ActionForm.php');
include_once(ETHNA_BASE . '/class/Ethna_AppManager.php');
include_once(ETHNA_BASE . '/class/Ethna_AppObject.php');
include_once(ETHNA_BASE . '/class/Ethna_AppSQL.php');
include_once(ETHNA_BASE . '/class/Ethna_AppSearchObject.php');
include_once(ETHNA_BASE . '/class/Ethna_Backend.php');
include_once(ETHNA_BASE . '/class/Ethna_Config.php');
include_once(ETHNA_BASE . '/class/Ethna_Controller.php');
include_once(ETHNA_BASE . '/class/Ethna_ClassFactory.php');
include_once(ETHNA_BASE . '/class/Ethna_DB.php');
include_once(ETHNA_BASE . '/class/DB/Ethna_DB_PEAR.php');
include_once(ETHNA_BASE . '/class/Ethna_Filter.php');
include_once(ETHNA_BASE . '/class/Ethna_I18N.php');
include_once(ETHNA_BASE . '/class/Ethna_LogWriter.php');
include_once(ETHNA_BASE . '/class/LogWriter/Ethna_LogWriter_Echo.php');
include_once(ETHNA_BASE . '/class/LogWriter/Ethna_LogWriter_File.php');
include_once(ETHNA_BASE . '/class/LogWriter/Ethna_LogWriter_Syslog.php');
include_once(ETHNA_BASE . '/class/Ethna_Logger.php');
include_once(ETHNA_BASE . '/class/Ethna_MailSender.php');
include_once(ETHNA_BASE . '/class/Ethna_Session.php');
include_once(ETHNA_BASE . '/class/Ethna_SkeltonGenerator.php');
include_once(ETHNA_BASE . '/class/Ethna_SmartyPlugin.php');
include_once(ETHNA_BASE . '/class/Ethna_Util.php');
include_once(ETHNA_BASE . '/class/Ethna_ViewClass.php');
include_once(ETHNA_BASE . '/class/AMF/Ethna_AMF_ActionClass.php');
include_once(ETHNA_BASE . '/class/CLI/Ethna_CLI_ActionClass.php');
include_once(ETHNA_BASE . '/class/View/Ethna_View_List.php');

if (extension_loaded('soap')) {
	include_once(ETHNA_BASE . '/class/SOAP/Ethna_SOAP_ActionForm.php');
	include_once(ETHNA_BASE . '/class/SOAP/Ethna_SOAP_Gateway.php');
	include_once(ETHNA_BASE . '/class/SOAP/Ethna_SOAP_GatewayGenerator.php');
	include_once(ETHNA_BASE . '/class/SOAP/Ethna_SOAP_Util.php');
	include_once(ETHNA_BASE . '/class/SOAP/Ethna_SOAP_WsdlGenerator.php');
}

/** 饤ȸ: Ѹ */
define('LANG_EN', 'en');

/** 饤ȸ: ܸ */
define('LANG_JA', 'ja');


/** 饤ȥ: ֥֥饦(PC) */
define('CLIENT_TYPE_WWW', 1);

/** 饤ȥ: SOAP饤 */
define('CLIENT_TYPE_SOAP', 2);

/** 饤ȥ: Flash Player (with Flash Remoting) */
define('CLIENT_TYPE_AMF', 3);

/** 饤ȥ: Х(AU) */
define('CLIENT_TYPE_MOBILE_AU', 4);


/** DB: R/W */
define('DB_TYPE_RW', 1);

/** DB: R/O */
define('DB_TYPE_RO', 2);

/** DB: Misc  */
define('DB_TYPE_MISC', 3);


/** Ƿ:  */
define('VAR_TYPE_INT', 1);

/** Ƿ: ư */
define('VAR_TYPE_FLOAT', 2);

/** Ƿ: ʸ */
define('VAR_TYPE_STRING', 3);

/** Ƿ:  */
define('VAR_TYPE_DATETIME', 4);

/** Ƿ:  */
define('VAR_TYPE_BOOLEAN', 5);

/** Ƿ: ե */
define('VAR_TYPE_FILE', 6);


/** ե෿: text */
define('FORM_TYPE_TEXT', 1);

/** ե෿: password */
define('FORM_TYPE_PASSWORD', 2);

/** ե෿: textarea */
define('FORM_TYPE_TEXTAREA', 3);

/** ե෿: select */
define('FORM_TYPE_SELECT', 4);

/** ե෿: radio */
define('FORM_TYPE_RADIO', 5);

/** ե෿: checkbox */
define('FORM_TYPE_CHECKBOX', 6);

/** ե෿: button */
define('FORM_TYPE_SUBMIT', 7);

/** ե෿: file */
define('FORM_TYPE_FILE', 8);


/** 顼: ̥顼 */
define('E_GENERAL', 1);

/** 顼: DB³顼 */
define('E_DB_CONNECT', 2);

/** 顼: DBʤ */
define('E_DB_NODSN', 3);

/** 顼: DBꥨ顼 */
define('E_DB_QUERY', 4);

/** 顼: DBˡ顼 */
define('E_DB_DUPENT', 5);

/** 顼: DB̥顼 */
define('E_DB_INVALIDTYPE', 6);

/** 顼: å󥨥顼(ͭڤ) */
define('E_SESSION_EXPIRE', 16);

/** 顼: å󥨥顼(IPɥ쥹å顼) */
define('E_SESSION_IPCHECK', 17);

/** 顼: ̤顼 */
define('E_APP_UNDEFINED_ACTION', 32);

/** 顼: 󥯥饹̤顼 */
define('E_APP_UNDEFINED_ACTIONCLASS', 33);

/** 顼: ץꥱ󥪥֥IDʣ顼 */
define('E_APP_DUPENT', 34);

/** 顼: ץꥱ᥽åɤ¸ߤʤ */
define('E_APP_NOMETHOD', 35);

/** 顼: å顼 */
define('E_APP_LOCK', 36);

/** 顼: CSVʬ䥨顼(Է³) */
define('E_UTIL_CSV_CONTINUE', 64);

/** 顼: եͷ顼(顼) */
define('E_FORM_WRONGTYPE_SCALAR', 128);

/** 顼: եͷ顼(˥顼) */
define('E_FORM_WRONGTYPE_ARRAY', 129);

/** 顼: եͷ顼() */
define('E_FORM_WRONGTYPE_INT', 130);

/** 顼: եͷ顼(ư) */
define('E_FORM_WRONGTYPE_FLOAT', 131);

/** 顼: եͷ顼(շ) */
define('E_FORM_WRONGTYPE_DATETIME', 132);

/** 顼: եͷ顼(BOOL) */
define('E_FORM_WRONGTYPE_BOOLEAN', 133);

/** 顼: եͷ顼(FILE) */
define('E_FORM_WRONGTYPE_FILE', 134);

/** 顼: եɬܥ顼 */
define('E_FORM_REQUIRED', 135);

/** 顼: եͺǾͥ顼() */
define('E_FORM_MIN_INT', 136);

/** 顼: եͺǾͥ顼(ư) */
define('E_FORM_MIN_FLOAT', 137);

/** 顼: եͺǾͥ顼(ʸ) */
define('E_FORM_MIN_STRING', 138);

/** 顼: եͺǾͥ顼(շ) */
define('E_FORM_MIN_DATETIME', 139);

/** 顼: եͺǾͥ顼(ե뷿) */
define('E_FORM_MIN_FILE', 140);

/** 顼: եͺͥ顼() */
define('E_FORM_MAX_INT', 141);

/** 顼: եͺͥ顼(ư) */
define('E_FORM_MAX_FLOAT', 142);

/** 顼: եͺͥ顼(ʸ) */
define('E_FORM_MAX_STRING', 143);

/** 顼: եͺͥ顼(շ) */
define('E_FORM_MAX_DATETIME', 144);

/** 顼: եͺͥ顼(ե뷿) */
define('E_FORM_MAX_FILE', 145);

/** 顼: եʸ(ɽ)顼 */
define('E_FORM_REGEXP', 146);

/** 顼: եͿ(å)顼 */
define('E_FORM_INVALIDVALUE', 147);

/** 顼: եʸ(å)顼 */
define('E_FORM_INVALIDCHAR', 148);

/** 顼: ǧѥȥϥ顼 */
define('E_FORM_CONFIRM', 149);


if (defined('E_STRICT') == false) {
	/** PHP 5Ȥθߴݻ */
	define('E_STRICT', 0);
}

/** EthnaХѿ: 顼Хåؿ */
$GLOBALS['_Ethna_error_callback_list'] = array();

/** EthnaХѿ: 顼å */
$GLOBALS['_Ethna_error_message_list'] = array();

/** EthnaХѿ: 饤ȼ */
$GLOBALS['_Ethna_client_type'] = null; 


// {{{ Ethna
/**
 *	Ethnaե졼饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Ethna
 */
class Ethna extends PEAR
{
	/**#@+
	 *	@access	private
	 */

	/**#@-*/

	/**
	 *	Ethna_Error֥Ȥ(顼٥:E_USER_ERROR)
	 *
	 *	@access	public
	 *	@param	string	$message			顼å
	 *	@param	int		$code				顼
	 *	@static
	 */
	function &raiseError($message, $code)
	{
		$userinfo = null;
		if (func_num_args() > 2) {
			$userinfo = array_slice(func_get_args(), 2);
			if (count($userinfo) == 1 && is_array($userinfo[0])) {
				$userinfo = $userinfo[0];
			}
		}
		return PEAR::raiseError($message, $code, PEAR_ERROR_RETURN, E_USER_ERROR, $userinfo, 'Ethna_Error');
	}

	/**
	 *	Ethna_Error֥Ȥ(顼٥:E_USER_WARNING)
	 *
	 *	@access	public
	 *	@param	string	$message			顼å
	 *	@param	int		$code				顼
	 *	@static
	 */
	function &raiseWarning($message, $code)
	{
		$userinfo = null;
		if (func_num_args() > 2) {
			$userinfo = array_slice(func_get_args(), 2);
			if (count($userinfo) == 1 && is_array($userinfo[0])) {
				$userinfo = $userinfo[0];
			}
		}
		return PEAR::raiseError($message, $code, PEAR_ERROR_RETURN, E_USER_WARNING, $userinfo, 'Ethna_Error');
	}

	/**
	 *	Ethna_Error֥Ȥ(顼٥:E_USER_NOTICE)
	 *
	 *	@access	public
	 *	@param	string	$message			顼å
	 *	@param	int		$code				顼
	 *	@static
	 */
	function &raiseNotice($message, $code)
	{
		$userinfo = null;
		if (func_num_args() > 2) {
			$userinfo = array_slice(func_get_args(), 2);
			if (count($userinfo) == 1 && is_array($userinfo[0])) {
				$userinfo = $userinfo[0];
			}
		}
		return PEAR::raiseError($message, $code, PEAR_ERROR_RETURN, E_USER_NOTICE, $userinfo, 'Ethna_Error');
	}

	/**
	 *	顼ȯ(ե졼ȤƤ)Хåؿꤹ
	 *
	 *	@access	public
	 *	@param	mixed	string:Хåؿ̾ array:Хå饹(̾|֥)+᥽å̾
	 *	@static
	 */
	function setErrorCallback($callback)
	{
		$GLOBALS['_Ethna_error_callback_list'][] = $callback;
	}

	/**
	 *	顼ȯνԤ(Хåؿ/᥽åɤƤӽФ)
	 *	
	 *	@access	public
	 *	@param	object	Ethna_Error		Ethna_Error֥
	 *	@static
	 */
	function handleError(&$error)
	{
		for ($i = 0; $i < count($GLOBALS['_Ethna_error_callback_list']); $i++) {
			$callback =& $GLOBALS['_Ethna_error_callback_list'][$i];
			if (is_array($callback) == false) {
				call_user_func($callback, $error);
			} else if (is_object($callback[0])) {
				$object =& $callback[0];
				$method = $callback[1];

				// perform some more checks?
				$object->$method($error);
			} else {
				call_user_func($callback, $error);
			}
		}
	}
}
// }}}
?>
