#include "vtkInteractorStyle.h"

#define VTKIS_CAMERA 0
#define VTKIS_ACTOR  1
#define SPACE ' '  

#include "vtkObjectFactory.h"
#include "vtkCommand.h"

class eosInteractorMyStyle : public vtkInteractorStyle
{
public:
  static eosInteractorMyStyle *New();
  vtkTypeMacro(eosInteractorMyStyle, vtkInteractorStyle);

  void UpdateInternalState(int ctrl, int shift,int X, int Y); 
  void OnLeftButtonDown(int ctrl, int shift,int x, int y);
  void OnLeftButtonUp(int ctrl, int shift,int x, int y);

  void OnMouseMove(int ctrl, int shift, int x, int y);
  void OnChar   (int ctrl, int shift, char keycode, int repeatcount);

  void SetInteractor(vtkRenderWindowInteractor *iren);
  void SetAutoAdjustCameraClippingRange( int value );

  //void SetRenderWindows(eosSetRenderWindow*);
  //void StartRotateMove();

protected:
  eosInteractorMyStyle();  
  //~eosInteractorMyStyle();  

  //  eosStereoWindow *StereoWin;
  int space;
 
};

//---------------------------------------------------------------------------
eosInteractorMyStyle *eosInteractorMyStyle::New() 
{
// First try to create the object from the vtkObjectFactory
  vtkObject* ret = vtkObjectFactory::CreateInstance("eosInteractorMyStyle");

  if(ret)
    {
    return (eosInteractorMyStyle*)ret;
    }
  // If the factory was unable to create the object, then create it here.
  return new eosInteractorMyStyle;
}


//----------------------------------------------------------------------------
eosInteractorMyStyle::eosInteractorMyStyle() 
{
  this->space=0;
}

//----------------------------------------------------------------------------
//eosInteractorMyStyle::~eosInteractorMyStyle() 
//{

//}

//----------------------------------------------------------------------------
void eosInteractorMyStyle::UpdateInternalState(int ctrl, int shift, 
                                             int X, int Y) 
{
  vtkInteractorStyle::UpdateInternalState(ctrl, shift , X, Y) ;

}

//----------------------------------------------------------------------------

void eosInteractorMyStyle::SetAutoAdjustCameraClippingRange( int value )
{
  if ( value == this->AutoAdjustCameraClippingRange )
    {
    return;
    }
  
  if ( value < 0 || value > 1 )
    {
    vtkErrorMacro("Value must be between 0 and 1 for" <<
                  " SetAutoAdjustCameraClippingRange");
    return;
    }
  
  this->AutoAdjustCameraClippingRange = value;

  this->Modified();
}

//----------------------------------------------------------------------------
void eosInteractorMyStyle::OnChar(int ctrl, int shift, 
                                      char keycode,
                                      int repeatcount) 
{

  vtkInteractorStyle::OnChar(ctrl, shift, keycode, repeatcount);

  switch (keycode)
    {
    case SPACE:
      if(this->space==0){this->space=1;}
      else              {this->space=0;}

      break;
    }
}

//----------------------------------------------------------------------------
void eosInteractorMyStyle::OnMouseMove(int ctrl, int shift, int x, int y) 
{
  // Call the parent so the LastPos is set
  vtkInteractorStyle::OnMouseMove(ctrl, shift, x, y);
}

//----------------------------------------------------------------------------

void eosInteractorMyStyle::OnLeftButtonDown(int ctrl, int shift,
                                                          int x, int y) 
{
  //
 this->UpdateInternalState(ctrl, shift ,x, y);
  //
  this->FindPokedCamera(x, y);

  if(this->space) 
    {
      this->StartSpin();
    }


  if (this->HasObserver(vtkCommand::LeftButtonPressEvent)) 
    {
    this->InvokeEvent(vtkCommand::LeftButtonPressEvent,NULL);
    }

  else 
    {
    if (this->ShiftKey) 
      { // I haven't got a Middle button !
      if (this->CtrlKey) 
        {
        this->StartDolly();
        }
      else 
        {
        this->StartPan();
        }
      } 

    else 
      {
      if (this->CtrlKey) 
        {
        this->StartSpin();
        }
      else 
        {
        this->StartRotate();
        }
      }
    }
}

//----------------------------------------------------------------------------
void eosInteractorMyStyle::OnLeftButtonUp(int ctrl, int shift,
                                              int x, int y) 
{
  //
 this->UpdateInternalState(ctrl, shift, X, Y);

 if(this->space) 
   {
     this->EndSpin();
   }


  //
  if (this->HasObserver(vtkCommand::LeftButtonReleaseEvent)) 
    {
    this->InvokeEvent(vtkCommand::LeftButtonReleaseEvent,NULL);
    }
  else 
    {
    if (this->ShiftKey) 
      {
      if (this->CtrlKey) 
        {
        this->EndDolly();
        }
      else
        {
        this->EndPan();
        }
      } 

    else 
      {
      if (this->CtrlKey) 
        {
        this->EndSpin();
        }
      else
        {
        this->EndRotate();
        }
      }
    }
}


//----------------------------------------------------------------------------
void eosInteractorMyStyle::SetInteractor(vtkRenderWindowInteractor *iren)
{
  this->vtkInteractorStyle::SetInteractor(iren);
}

//----------------------------------------------------------------------------
//void eosInteractorMyStyle::StartRotateMove()
//{

//}

//----------------------------------------------------------------------------
//void eosInteractorMyStyle::SetRenderWindows(eosStereoRenderWindow* renwin)
//{
//  this->StereoWin=renwin;
//}
