/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.sip;

import javax.sip.RequestEvent;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.header.FromHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.xml.parsers.ParserConfigurationException;

import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityContainerImpl;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.entity.EntityInformation;
import jp.ac.naka.ec.entity.EntityInformationParser;
import jp.ac.naka.ec.entity.EntityEvent.EventType;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

/**
 * @author Takashi Kasuya
 * 
 */
class NotifyDelegate implements MethodDelegate {

	private static Log logger = LogFactory.getLog(NotifyDelegate.class);
	//private PIDFParserImpl parser;
	private EntityInformationParser parser;
	private static SipCore core;
	private static EntityContainer container;
	/**
	 * 
	 * @throws ParserConfigurationException
	 * @throws SAXException
	 */
	public NotifyDelegate() throws ParserConfigurationException, SAXException {
		parser = EntityInformationParser.getInstance();
		core = SipCore.getInstance();
		container = EntityContainerImpl.getInstance();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.ac.naka.sip.delegate.MethodDelegate#forward(javax.sip.RequestEvent)
	 */
	public boolean forward(RequestEvent evt) {
		logger.info("Notify Request from " + evt.getRequest().getRequestURI().toString());

		Request req = evt.getRequest();
		byte[] content = req.getRawContent();

		EntityInformation data;
		try {
			FromHeader from = (FromHeader) req.getHeader(FromHeader.NAME);
			Address addr = from.getAddress();
			
			if (content == null) {
				core.sendResponse(Response.OK, evt, addr.getURI().toString());
				return false;
			}
			data = parser.parse(content);
			//System.out.println(data);
			
			if (data != null) {
				Entity source = new EntityImpl(data);
				ToHeader to = (ToHeader)req.getHeader(ToHeader.NAME);
				SipURI toUri = (SipURI)to.getAddress().getURI();
				Entity target = container.getEntity(toUri.toString());
				if (target == null) 
					throw new NullPointerException(toUri + " is null!");
				
				EntityEvent e = new EntityEvent("", target, source, EventType.NOTIFY);
				if (target instanceof AbstractEntity)
					((AbstractEntity)target).handleEvent(e);
				else 
					target.receiveNotify(e);
			}

			// 200 OK
			core.sendResponse(Response.OK, evt, addr.getURI().toString());
			
			
		} catch (Exception e) {
			logger.warn("Error occures while processing PIDF :", e);
			return false;
		}
		return true;
	}

	
}
