/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.entity;

import java.util.EventObject;

import javax.sdp.SessionDescription;
import javax.sip.address.SipURI;
import javax.sip.message.Request;

/**
 * 
 * @author Takashi Kasuya
 *
 */
public class EntityEvent extends EventObject {

	
	private static final long serialVersionUID = -5024101656766992758L;
	private EntityListener target;
	private String message;

	private SessionDescription sdp;
	private Request request;
	private EventType type;
	private int statusCode;

	
	
	
	
	/**
	 * 
	 * @param target
	 * @param source
	 * @param type
	 */
	public EntityEvent(EntityListener target, Entity source, EventType type) {
		this("", target, source, type);
	}
	
	/**
	 * bZ[W̓`dɗp
	 * @param message
	 * @param target
	 * @param source
	 * @param type
	 */
	public EntityEvent(String message, EntityListener target, Entity source, EventType type) {
		super(source);
		this.message = message;
		this.target = target;
		this.type = type;
	}

	/**
	 * bZ[W̓`dɗpBCxg^CvMESSAGEB
	 * @param message
	 * @param target
	 * @param source
	 */
	public EntityEvent(String message, EntityListener target, Entity source) {
		super(source);
		this.message = message;
		this.target = target;
		this.type = EventType.MESSAGE;
	}

	
	/**
	 * OfferM̍ۂɗp
	 * @param sdp
	 * @param target
	 * @param source
	 */
	public EntityEvent(SessionDescription sdp, EntityListener target, Entity source) {
		this("", target, source);
		this.type = EventType.OFFER;
		this.sdp = sdp;
	}

	/**
	 * AnswerCxg̍ۂɗp
	 * @param sdp2
	 * @param source
	 */
	public EntityEvent(SessionDescription sdp2, Entity source) {
		super(source);
		this.sdp = sdp2;
		this.type = EventType.ANSWER;
	}

	/**
	 * 
	 * @return
	 */
	public EntityListener getTarget() {
		return this.target;
	}

	/**
	 * 
	 * @return
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * 
	 * @param message
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * 
	 * @return
	 */
	public SessionDescription getSessionDescription() {
		return sdp;
	}

	
	/**
	 * 
	 * @return
	 */
	public EventType getEventType() {
		return type;
	}

	/**
	 * 
	 * @param type
	 */
	public void setEventType(EventType type) {
		this.type = type;
	}

	/**
	 * 
	 * @author J
	 *
	 */
	public static enum EventType {
		MESSAGE, LOCATION, INIT,REGISTER,OFFER, ADD, ANSWER, IMAGE, BYE, SUBSCRIBE, NOTIFY, ACK, REMOVE, ERROR;
	}

	/**
	 * 
	 * @return
	 */
	public Request getRequest() {
		return request;
	}

	/**
	 * 
	 * @param req
	 */
	public void setRequest(Request req) {
		this.request = req;
	}

	


	/*
	 * (non-Javadoc)
	 * @see java.util.EventObject#toString()
	 */
	public String toString() {
		return "Target :" + target + ", Type :" + type.toString();
	}

	public void setStatusCode(int statusCode) {
		this.statusCode = statusCode;
	}
	
	public int getStatusCode (){
		return statusCode;
	}

}
