/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.entity;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.text.ParseException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.sdp.SessionDescription;
import javax.sip.address.SipURI;
import jp.ac.naka.ec.dht.Chord;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityEventDispatcher;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.sip.SipCore;

public class EntityContainerImpl
extends EntityImpl
implements EntityContainer {
    Map<String, Entity> entities = new HashMap<String, Entity>();
    private static EntityContainerImpl instance;
    private static Chord chord;

    static {
        try {
            instance = new EntityContainerImpl();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    private EntityContainerImpl() throws IOException, ParseException {
        String hostname = EntityContainerImpl.getHostName();
        String ipAddr = EntityContainerImpl.getIpAddress(hostname);
        SipURI uri = EntityContainerImpl.createSipURI("sip:" + hostname + "@" + ipAddr + ":" + SipCore.PORT);
        this.setURI(uri);
        EntityEventDispatcher dispatcher = EntityEventDispatcher.getInstance();
        dispatcher.addEntityListener(this);
    }

    public static EntityContainerImpl getInstance() {
        return instance;
    }

    public static EntityContainerImpl getInstance(String ni) throws IOException, ParseException {
        String ipAddr = EntityContainerImpl.getIpAddressOf(ni);
        SipURI uri = EntityContainerImpl.createSipURI("sip:" + ni + "@" + ipAddr + ":" + SipCore.PORT);
        instance.setURI(uri);
        return instance;
    }

    public void addEntity(Entity e) {
        e.setEntityContainer(this);
        String host = this.getURI().getHost();
        try {
            SipURI uri;
            String name = e.getName();
            if (name == null) {
                name = e.getClass().getName();
                uri = EntityContainerImpl.createSipURI("sip:" + name + "@" + host + ":" + SipCore.PORT);
                e.setURI(uri);
            } else if (e.getURI() == null) {
                uri = EntityContainerImpl.createSipURI("sip:" + name + "@" + host + ":" + SipCore.PORT);
                e.setURI(uri);
            }
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        if (this.getKeywords() != null || this.getKeywords().length != 0) {
            String[] stringArray = this.getKeywords();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String keyword = stringArray[n2];
                e.addKeyword(keyword);
                ++n2;
            }
        }
        String str = this.checkURI(e.getURI().toString());
        this.entities.put(str, e);
    }

    private String checkURI(String string) {
        int index = string.indexOf(";");
        if (index == -1) {
            return string;
        }
        String sub = string.substring(0, index);
        return sub;
    }

    public void removeEntity(Entity entity) {
        if (this.entities.containsValue(entity)) {
            this.entities.remove(entity.getURI().toString());
        }
    }

    public Entity[] getEntities() {
        Entity[] ee = new Entity[this.entities.size()];
        int num = 0;
        Set<String> set = this.entities.keySet();
        for (String key : set) {
            ee[num++] = this.entities.get(key);
        }
        return ee;
    }

    public Entity getEntity(String uri) {
        Entity entity = this.entities.get(uri);
        return entity;
    }

    public Entity[] searchEntities(String keyword) {
        if (chord == null) {
            chord = Chord.getInstance();
        }
        if (!chord.isInitiated()) {
            return new Entity[0];
        }
        Entity[] external = chord.getEntities(keyword);
        int i = 0;
        while (i < external.length) {
            Entity entity = external[i];
            Entity temp = this.entities.get(entity.getURI().toString());
            if (temp != null) {
                external[i] = temp;
            }
            ++i;
        }
        return external;
    }

    public void receiveMessage(EntityEvent e) {
        if (!this.isLocal()) {
            return;
        }
        switch (e.getEventType()) {
            case MESSAGE: {
                this.procMessage(e);
                break;
            }
            case INIT: {
                break;
            }
            default: {
                throw new UnsupportedOperationException((Object)((Object)e.getEventType()) + " is not Supported.");
            }
        }
    }

    public void receiveAck(EntityEvent evt) {
    }

    private void procMessage(EntityEvent e) {
        Collection<Entity> list = this.entities.values();
        Entity source = (Entity)e.getSource();
        for (Entity entity : list) {
            if (source.equals(entity)) continue;
            if (entity instanceof AbstractEntity) {
                ((AbstractEntity)entity).handleEvent(e);
                continue;
            }
            entity.receiveMessage(e);
        }
    }

    public SessionDescription receiveOffer(EntityEvent e) {
        Entity target = (Entity)e.getTarget();
        SessionDescription sdp = null;
        Entity entity = this.entities.get(target.getURI().toString());
        if (entity != null) {
            sdp = entity.receiveOffer(e);
        }
        if (sdp == null) {
            return null;
        }
        Entity source = (Entity)e.getSource();
        return null;
    }

    public void receiveAnswer(EntityEvent e) {
        Entity target = (Entity)e.getTarget();
        Entity entity = this.entities.get(target.getURI().toString());
        if (entity != null) {
            entity.receiveAnswer(e);
        }
    }

    public void receiveBye(EntityEvent e) {
        Entity target = (Entity)e.getTarget();
        Entity entity = this.entities.get(target.getURI().toString());
        if (entity != null) {
            entity.receiveBye(e);
        }
    }

    public static String getIpAddress(String hostname) throws IOException {
        String address = "";
        address = InetAddress.getByName(hostname).getHostAddress();
        return address;
    }

    public static String getIpAddressOf(String niName) throws IOException {
        String address = "";
        Enumeration<NetworkInterface> enuIfs = NetworkInterface.getNetworkInterfaces();
        if (enuIfs != null) {
            block0: while (enuIfs.hasMoreElements()) {
                NetworkInterface ni = enuIfs.nextElement();
                if (!ni.getName().equals(niName)) continue;
                Enumeration<InetAddress> enuAddrs = ni.getInetAddresses();
                while (enuAddrs.hasMoreElements()) {
                    InetAddress in4 = enuAddrs.nextElement();
                    if (!(in4 instanceof Inet4Address)) continue;
                    address = in4.getHostAddress();
                    continue block0;
                }
            }
        }
        String hostname = InetAddress.getLocalHost().getHostName();
        System.out.println("Use Interface :" + hostname + ", " + address);
        return address;
    }

    public static String getHostName() throws IOException {
        String name = InetAddress.getLocalHost().getHostName();
        return name;
    }
}

